<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://symaticsolutions.com
 * @since      1.0.0
 *
 * @package    Symatic_Bible_Index
 * @subpackage Symatic_Bible_Index/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Symatic_Bible_Index
 * @subpackage Symatic_Bible_Index/includes
 * @author     Symatic Solutions <info@symaticsolutions.com>
 */
class Symatic_Bible_Index_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'symatic-bible-index',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
