<?php

/**
 * Template Name: Chapter
 */

/** This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
get_header();
?>

	<div id="primary" class="fixed-width">

		<div id="content" role="main" style="font-family:<?php echo $font_style;?>;font-size:<?php echo $bible_font_size;?>;">

		<?php

		global $isChapter,$postTitle;

			if($cat==0):
				$page = get_page(36823);
				$page_subtitle	= get_post_meta( $page->ID, '_subtitle', true );
				?>

				<article class="post-36823 post type-post status-publish format-standard hentry category-genesis category-theword" id="post-36823">
					<header class="entry-header">
						<h1 style="<?php if(!empty($line_height)){echo "line-height:".$line_height.";";}?>;font-size:<?php echo $bible_font_size;?>;" class="entry-title">
							<span class="entry-title-primary"><?php echo $page->post_title;?></span>
							<span class="entry-subtitle"><?php echo $page_subtitle;?></span>
						</h1>
					</header><!-- .entry-header -->

					<div class="entry-content">
						<center>"<?php echo $page->post_content;?>"</center>
					</div><!-- .entry-content -->
				</article>
			<?php

			/* Removing following condition.  */

			elseif($isChapter === true && !isset($_GET['v'])):
            /* Removing following condition.  */
				$single_post_id = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_name = '$postTitle'");
				$page = get_post($single_post_id);?>

				<article class="post-<?php echo $single_post_id;?> post type-post status-publish format-standard hentry category-genesis category-theword singlePage" id="post-<?php echo $single_post_id;?>">
					<header class="entry-header">
						<h1 style="<?php if(!empty($line_height)){echo "line-height:".$line_height.";";}?>;font-size:<?php echo $bible_font_size;?>;text-transform:uppercase;font-weight: bold;" class="entry-title hide-subtitle"><span class="entry-title-primary"><?php echo $page->post_title;?></span></h1>
					</header><!-- .entry-header -->

					<div class="entry-content">
				        <center>"<?php echo $page->post_content;?>"</center>
                    </div><!-- .entry-content -->
				</article>

				<p class="read-full-chapter"><a href="<?php echo get_permalink(36823).get_cat_slug($cat)."/".$chapter."?v=".$wp_query->query_vars['ch'];?>">Read the Full Chapter</a></p> 
				<!--  <p class="read-full-chapter"><a href="<?php echo get_permalink(36823).get_cat_slug($cat)."/".$wp_query->query_vars['ch']."/?v";?>">Read the Full Chapter</a></p> -->
				<nav class="nav-single">
					<h3 class="assistive-text"><?php _e( 'Post navigation', 'twentytwelve' ); ?></h3>
					<?php

					if(!empty($cat)) {
                        $prev_post = get_bible_prev_post($cat, $single_post_id);
                        $next_post = get_bible_next_post($cat, $single_post_id);
                    }

					?>

					<?php if($prev_post):?>
							<span class="nav-previous"><a href="<?php echo get_permalink($prev_post);?>"><?php echo "<< " . get_the_title($prev_post);?></a></span>
					<?php endif;?>

					<?php if($next_post):?>
						<span class="nav-next"><a href="<?php echo get_permalink($next_post);?>"><?php echo get_the_title($next_post)." >>";?></a></span>
					<?php endif;?>

				</nav><!-- .nav-single -->	

				<?php	

			else:
                global $post, $wp;
                $cateid = get_site_option('symatic_strong_cat');
				$cat_name	=	 get_cat_name($cat);

				//symatic
				if($cateid == $cat){
                    echo '<h3 class="page-title" style="font-size:'.$bible_font_size.';">'.$postTitle.'</h3>';
                    $args = array(
                        'name'        => $postTitle,
                        'post_type'   => 'post',
                        'post_status' => 'publish',
                        'numberposts' => 1
                    );

                    //echo '<pre>';print_r(get_posts($args));exit;

                    query_posts($args);

                    while ( have_posts() ){
                        the_post();
                        //the_content();
                        get_template_part( 'content', 'strongs' );
                    }
                }else{
                    echo '<h3 class="page-title" style="font-size:'.$bible_font_size.';">'.$cat_name;
                    if($chapter==0 && !isset($_GET['v'])){
                        echo " Introduction";
                    }elseif($chapter==0 && isset($_GET['v'])){
                        echo " ".str_replace("-"," ",$ch_title);
                    }else{
                        echo " Chapter ".$chapter;
                    }
                    echo '</h3>';

                    $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;

                    $query_args = array(
                        'post_type' => 'post',
                        'cat' =>$cat,
                        'meta_key' => 'bible_chapter',
                        'meta_value'	=> str_replace(" ","",$cat_name)."-".$ch_title,
                        'posts_per_page' => -1,
                        'paged' => $paged,
                        'orderby'=>'ID',
                        'order'=>'ASC'
                    );

                    query_posts($query_args);

                    while ( have_posts() ){
                        the_post();
                        $bible_chapter = get_post_meta( get_the_ID(), 'bible_chapter', true );
                        get_template_part( 'content', 'chapter' );
                    }

                    $index 		= array_search($cat, $arr_cats);
                    $last_index	= sizeof($arr_cats)-1;

                    ?>
                    <nav class="nav-single">

                        <?php
                        if($chapter>$arr_first_chap[$cat]) {
                            $chapter_string = "";

                            if ($chapter == 1 && $arr_first_chap[$cat] == 0) {
                                $chapter_string = " Introduction";
                            } else {
                                $chapter_string = " Chapter " . ($chapter - 1);
                            }
                            ?>

                            <div class="nav-previous alignleft"><a
                                        href="<?php echo get_permalink(36823) . get_cat_slug($cat) . "/" . ($chapter - 1); ?>"><?php echo "<< " . $cat_name . $chapter_string; ?></a>
                            </div>

                            <?php
                        }elseif($chapter==$arr_first_chap[$cat]&&$index!=0){
                            $prev_cat 		= $arr_cats[$index-1];
                            $prev_cat_name 	= get_cat_name($prev_cat);
                            ?>

                            <div class="nav-previous alignleft"><a href="<?php echo get_permalink(36823).get_cat_slug($prev_cat)."/".($arr_last_chap[$prev_cat]);?>"><?php echo "<< ".$prev_cat_name." Chapter ".($arr_last_chap[$prev_cat]);?></a></div>

                            <?php
                        }
                        ?>

                        <?php if($chapter < $arr_last_chap[$cat]):?>

                            <div class="nav-next alignright"><a href="<?php echo get_permalink(36823).get_cat_slug($cat)."/".($chapter+1);?>"><?php echo $cat_name." Chapter ".($chapter+1)." >>";?></a></div>

                        <?php elseif($last_index>$index && $chapter == $arr_last_chap[$cat]):?>

                            <?php $next_cat 		= $arr_cats[$index+1];?>

                            <?php $next_cat_name 	= get_cat_name($next_cat);;?>

                            <?php
                            $chapter_string="";
                            if($arr_first_chap[$next_cat]==0):
                                $chapter_string	=	" Introduction";
                            else:
                                $chapter_string	=	" Chapter ".$arr_first_chap[$next_cat];
                            endif;

                            ?>
                            <div class="nav-next alignright"><a href="<?php echo get_permalink(36823).get_cat_slug($next_cat)."/".($arr_first_chap[$next_cat]);?>"><?php echo $next_cat_name. $chapter_string.">>";?></a></div>
                        <?php endif;?>
                    </nav>
                    <?php
                }
                ?>
					<?php wp_reset_query();

				endif;?>

		</div><!-- #content -->

	</div><!-- #primary -->

<?php //get_sidebar(); ?>

<?php get_footer(); ?>