<?php
/**
 * The Template for displaying all single posts
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */

get_header(); ?>

	<div id="primary" class="fixed-width">
		<div id="content" role="main" style="font-family:<?php echo $font_style;?>;font-size:<?php echo $bible_font_size;?>;">

			<?php while ( have_posts() ) : the_post(); ?>

				<?php get_template_part( 'content','post'); ?>
				<nav class="nav-single">
					<h3 class="assistive-text"><?php _e( 'Post navigation', 'twentytwelve' ); ?></h3>
					<?php $prev_post	=	get_the_ID()-1;?>
					<?php $next_post	=	get_the_ID()+1;?>
					<?php if($prev_post):?>
							<span class="nav-previous"><a href="<?php echo get_permalink(get_the_ID()-1);?>"><?php echo "<< " . get_the_title(get_the_ID()-1);?></a></span>
					<?php endif;?>
					<?php if($next_post):?>
						<span class="nav-next"><a href="<?php echo get_permalink(get_the_ID()+1);?>"><?php echo get_the_title(get_the_ID()+1)." >>";?></a></span>
					<?php endif;?>
				</nav><!-- .nav-single -->

				<?php //comments_template( '', true ); ?>

			<?php endwhile; // end of the loop. ?>
		</div><!-- #content -->
	</div><!-- #primary -->

<?php //get_sidebar(); ?>
<?php get_footer(); ?>