<?php
/**
 * The Header template for our theme
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
 error_reporting(0);
?><!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->

<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri();?>/css/dropmenu.css">
<?php // Loads HTML5 JavaScript file to add support for HTML5 elements in older IE versions. ?>
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
<![endif]-->
<link rel="stylesheet" href="http://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css">
<link href='http://fonts.googleapis.com/css?family=Merriweather:400,700' rel='stylesheet' type='text/css'>
 <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
<?php wp_head(); ?>
</head>
<?php 
global $bible_theme_color,$theme_color;
$bible_theme_color = $_COOKIE['theme_color']; ?>
<?php if($bible_theme_color == 'water'):?>
	<?php $theme_color="watertheme";?>
<?php else:?>
	<?php $theme_color="";?>
<?php endif;?>
<?php
global $bible_font_style,$font_style;
 $bible_font_style = $_COOKIE['font_style']; ?>
<?php 
global $bible_font_size,$line_height;
$bible_font_size = ($_COOKIE['font_size']? $_COOKIE['font_size'] : "12px"); ?>
<?php if($bible_font_style == 'font-merriweather'):?>
	<?php $font_style="'Merriweather', serif";?>
<?php elseif($bible_font_style == 'font-timesnewroman'):?>
	<?php $font_style="Times New Roman";?>
<?php else:?>
	<?php $font_style="Helvetica, Arial, sans-serif";?>
<?php endif;?>
<?php global $ch_title,$cat,$chapter;?>
	<?php $chapter	=	($_GET['ch'] ? $_GET['ch'] : '0'); ?>
	<?php $ch_title	=	"chapter-".$chapter;?>
	<?php $ch_name	=	"Chapter ".$chapter;?>
	<?php $cat		=	($_GET['cat'] ? $_GET['cat'] : '0');  ?>
<body <?php body_class($theme_color);?>>
	<div id="page" class="hfeed site">
	<header id="masthead" class="site-header" role="banner">
		
        <div class="fixed-width">
        <hgroup>
			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
			<h2 class="site-description"><?php //bloginfo( 'description' ); ?></h2>
		</hgroup>

		<nav id="site-navigation" class="main-navigation" role="navigation">
			<h3 class="menu-toggle"><?php _e( 'Menu', 'twentytwelve' ); ?></h3>
			<a class="assistive-text" href="#content" title="<?php esc_attr_e( 'Skip to content', 'twentytwelve' ); ?>"><?php _e( 'Skip to content', 'twentytwelve' ); ?></a>
			<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) ); ?>
		</nav><!-- #site-navigation -->
        
        
		<!--Menu Book Chapter-->
        <div id="menu_book_chapter" class="dynamic_menu" style="left: 353.5px;top: 151px; display: none;">
			<div class="mobile">
				<div class="reader_modal_header">
					<nav>
						<a class="close_btn reference_close_btn">X</a>
					</nav>
				</div>
				<div class="tab_navigation ref">
					<div class="inner_wrapper">
						<a href="#book" class="book selected">
							<span title="translation missing: en.Book" class="translation_missing">Book</span>
						</a>
						<a href="#chapter" class="chapter">
							<span title="translation missing: en.Chapter" class="translation_missing">Chapter</span>
						</a>
					</div>
				</div>
			</div>
			<br class="clear">
			<div style="display: none;" class="spinner_wrapper">
				<div id="book_chapter_spinner" class="dynamic_menu_spinner"></div>
			</div>
			<div class="browse">
				<span class="menu_arrow">
					&nbsp;
				</span>
				<div id="menu_book">
					<header>
						Book
					</header>
					<div class="scroll">
						<ul class="books">
							<?php
								global $wpdb;
								$query = "SELECT `bible_terms`.`term_id` as term_id,`bible_terms`.`name` as name FROM `bible_terms` left join `bible_term_taxonomy` on `bible_terms`.`term_id` = `bible_term_taxonomy`.`term_id` where `bible_term_taxonomy`.`parent`='4'";
								$categories	= $wpdb->get_results($query);
								$active="";
								if($categories):?>
									<?php foreach($categories as $category):?>
									<li data-meta="<?php echo $category->name;?>">
										<?php if($cat==0){$cat=5;}?>
										<?php if($cat == $category->term_id):?>
												<?php $active="active";?>
										<?php else:?>
												<?php $active="";?>
										<?php endif; ?>
										<a href="javascript:void(0)" data-book="<?php echo $category->term_id;?>"class="<?php echo $active;?>"><?php echo $category->name;?></a>
									</li>
								<?php endforeach;?>
							<?php endif;?>
						</ul>
					</div>
				</div>
				<div id="menu_chapter">
					<header>
						Chapter
					</header>
					<div class="scroll">
					<?php
						global $arr_last_chap;
						$display="";
						foreach($categories as $category):
							$cat_id = $category->term_id;
							$query = "SELECT chapter FROM `bible_chapter` 
							WHERE `category_id` = $cat_id order by id";
							$chapter_arr=array();
							$chapter_arr	= $wpdb->get_results($query);
							$counter=0;
							echo '<ol id="chapter_selector_'.$category->term_id .'">';
								foreach($chapter_arr as $chap):?>
									<?php $chap_pos	=	strripos($chap->chapter,"-",0);?>
									<?php $chapt	=	substr($chap->chapter,$chap_pos+1);?>
									<?php if($chapter == $chapt && $cat==$cat_id):?>
												<?php $active="active";?>
										<?php else:?>
												<?php $active="";?>
										<?php endif; ?>
									<li class=" canonical">
										<a href="<?php echo esc_url( add_query_arg( array('ch' => $chapt,'cat'=> $category->term_id), get_permalink(36823) ) );?>" class="<?php echo $active;?>"><?php echo $chapt;?></a>
									</li>
								<?php
								endforeach;
							echo '</ol>';
							$arr_last_chap[$category->term_id]=$chapt;
						
						endforeach;
					?>	
					</div>
				</div>
			</div>
		</div>
		<!--#Menu Book Chapter-->
		
		<!--Menu Dozen-->
		<div style="display: none;" id="menu_dozen" data-link-needs-param="false" class="menu-other menu_dozen dynamic_menu version_select">
			<div class="mobile">
				<div class="reader_modal_header">
					<nav>
						<a class="close_btn version_close_btn"></a>
					</nav>
				</div>
			</div>
			<div style="display: none;" class="spinner_wrapper">
				<div id="version_spinner" class="dynamic_menu_spinner"></div>
			</div>
			<div class="browse">
				<span class="menu_arrow">&nbsp;</span>
				<ul class="dozen other">
					<?php $args = array(
								  'orderby' => 'name',
								  'order' => 'ASC',
								  'child_of'=>10,
								  'hide_empty'=>0
								  ); 
							?>
					<?php  $categories = get_categories($args); ?>
					<?php foreach($categories as $category):?>
						<li data-meta="<?php echo $category->name;?>">
							<a href="<?php echo get_category_link($category->term_id);?>" data-book="<?php echo $category->term_id;?>"><?php echo $category->name;?></a>
						</li>
						
					<?php endforeach;?>
				</ul>
			</div>
		</div>
		<!--#Menu Dozen-->
		
		<!--Menu Truth-->
		<div style="left:638.5px ;top: 151px; display: none;" id="menu_truth" data-link-needs-param="false" class="menu_truth menu-other dynamic_menu version_select">
			<div class="mobile">
				<div class="reader_modal_header">
					<nav>
						<a class="close_btn version_close_btn"></a>
					</nav>
				</div>
			</div>
			<div style="display: none;" class="spinner_wrapper">
				<div id="version_spinner" class="dynamic_menu_spinner"></div>
			</div>
			<div class="browse">
				<span class="menu_arrow">&nbsp;</span>
				<ul class="other">
					<?php $args = array(
								  'orderby' => 'name',
								  'order' => 'ASC',
								  'child_of'=>23,
								  'hide_empty'=>0
								  ); 
							?>
					<?php  $categories = get_categories($args); ?>
					<?php foreach($categories as $category):?>
						<li data-meta="<?php echo $category->name;?>">
							<a href="<?php echo get_category_link($category->term_id);?>" data-book="<?php echo $category->term_id;?>"><?php echo $category->name;?></a>
						</li>
						
					<?php endforeach;?>
				</ul>
			</div>
		</div>
		<!--#Menu Truth-->
		
		<!--Menu Falsehoods-->
		<div style="left:750.5px; top:151px; display: none;" id="menu_falsehoods" data-link-needs-param="false" class="menu_falsehoods menu-other dynamic_menu version_select">
			<div class="mobile">
				<div class="reader_modal_header">
					<nav>
						<a class="close_btn version_close_btn"></a>
					</nav>
				</div>
			</div>
			<div style="display: none;" class="spinner_wrapper">
				<div id="version_spinner" class="dynamic_menu_spinner"></div>
			</div>
			<div class="browse">
				<span class="menu_arrow">&nbsp;</span>
				<ul class="other">
					<?php $args = array(
								  'orderby' => 'name',
								  'order' => 'ASC',
								  'child_of'=>27,
								  'hide_empty'=>0
								  ); 
							?>
					<?php  $categories = get_categories($args); ?>
					<?php foreach($categories as $category):?>
						<li data-meta="<?php echo $category->name;?>">
							<a href="<?php echo get_category_link($category->term_id);?>" data-book="<?php echo $category->term_id;?>"><?php echo $category->name;?></a>
						</li>
						
					<?php endforeach;?>
				</ul>
			</div>
		</div>
		<!--#Menu Falsehoods-->
		
		<!--Menu Other-->
		<div style="display: none;" data-link-needs-param="false" class="dynamic_menu version_select menu-other">
			
		</div>
		<!--#Menu Other-->
	
		<!--Search Form-->
        <div class="Searchform">
		
    <form role="search" method="get" id="searchform" class="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<div>
		<label class="screen-reader-text" for="s"><?php _x( 'Search for:', 'label' ); ?></label>
		<input type="text" value="<?php echo get_search_query(); ?>" name="s" id="s" />
		<input type="submit" id="searchsubmit" value="<?php echo esc_attr_x( 'Search', 'submit button' ); ?>" />
	</div>
</form>
    </div>
    
    <div class="setting-icon">
		<a href="#" data-toggle="modal" data-target="#setting-modal"><img src='<?php echo get_template_directory_uri(); ?>/images/setting-icon.png'></a>
    </div>
     
        
        </div>
        <?php if ( get_header_image() ) : ?>
		<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php header_image(); ?>" class="header-image" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt="" /></a>
		<?php endif; ?>
	</header><!-- #masthead -->
	
	
	<div id="main" class="wrapper">
		<div class="breadcrumbs" style="font-family:<?php echo $font_style;?>;font-size:<?php echo $bible_font_size;?>;">
			<?php if(!is_page('chapter') && !is_home()):?>
				<?php if(function_exists('bcn_display'))
				{
					bcn_display();
				}?>
			<?php elseif(!is_home()&& $chapter!="0"):?>
				<span typeof="v:Breadcrumb">
					<a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
				</span>
				&gt; 
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_category_link(4);?>" title="Go to the <?php echo get_cat_name(4);?> category archives." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
				</span>
				&gt;
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_category_link($cat);?>" title="Go to the <?php echo get_cat_name($cat);?> category archives." property="v:title" rel="v:url"><?php echo get_cat_name($cat);?></a>
				</span> 
				&gt; 
				<span typeof="v:Breadcrumb"><span property="v:title" class="chapter-title"><?php echo $ch_name;?></span></span>
			<?php elseif(!is_home()&& $chapter=="0" && (is_page('chapter'))):?>
				<span typeof="v:Breadcrumb">
					<a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
				</span>
				&gt; 
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_category_link(4);?>" title="Go to the <?php echo get_cat_name(4);?> category archives." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
				</span>
				&gt;
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_category_link($cat);?>" title="Go to the <?php echo get_cat_name($cat);?> category archives." property="v:title" rel="v:url"><?php echo get_cat_name($cat);?></a>
				</span> 
				&gt; 
				<span typeof="v:Breadcrumb"><span property="v:title" class="chapter-title">Introduction</span></span>
			<?php endif;?>
		</div>
		
		