<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
?>
<?php $bible_font_size = ($_COOKIE['font_size']? $_COOKIE['font_size'] : "12px");?>
<?php 
if($bible_font_size=='12px'):
	$line_height='35px';
elseif($bible_font_size=='14px'):
	$line_height='40px';
elseif($bible_font_size=='16px'):
	$line_height='44px';
elseif($bible_font_size=='18px'):
	$line_height='50px';
elseif($bible_font_size=='22px'):
	$line_height='60px';
endif;
?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
		<div class="featured-post">
			<?php _e( 'Featured post', 'twentytwelve' ); ?>
		</div>
		<?php endif; ?>
		<header class="entry-header">
			<?php if ( ! post_password_required() && ! is_attachment() ) :
				the_post_thumbnail();
			endif; ?>

			<?php if ( is_single() ) : ?>
			<h1 class="entry-title" style="font-size:<?php echo $bible_font_size;?>;"><?php the_title(); ?></h1>
			<?php else : ?>
			<h1 class="entry-title" style="<?php if(!empty($line_height)){echo "line-height:".$line_height.";";}?>">
				<a href="<?php the_permalink(); ?>" rel="bookmark" style="font-size:<?php echo $bible_font_size;?>;"><?php echo get_post_meta(get_the_ID(),'_subtitle',true); ?></a>
			</h1>
			<?php endif; // is_single() ?>
			<?php /*if ( comments_open() ) : ?>
				<div class="comments-link">
					<?php comments_popup_link( '<span class="leave-reply">' . __( 'Leave a reply', 'twentytwelve' ) . '</span>', __( '1 Reply', 'twentytwelve' ), __( '% Replies', 'twentytwelve' ) ); ?>
				</div><!-- .comments-link -->
			<?php endif; // comments_open() */?>
		</header><!-- .entry-header -->

		<?php if ( is_search() ) : // Only display Excerpts for Search ?>
		<div class="entry-summary">
			<?php the_excerpt(); ?>
		</div><!-- .entry-summary -->
		<?php else : ?>
		<div class="entry-content">
			<?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'twentytwelve' ) ); ?>
			<?php wp_link_pages( array( 'before' => '<div class="page-links">' . __( 'Pages:', 'twentytwelve' ), 'after' => '</div>' ) ); ?>
		</div><!-- .entry-content -->
		<?php endif; ?>
	</article><!-- #post -->
