<?php
/**
 * The template for displaying Category pages
 *
 * Used to display archive-type pages for posts in a category.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */

get_header();?>
	<section id="primary" class="fixed-width">
		<div id="content" role="main">
		<?php
			global $wpdb;
			$query = "SELECT `bible_terms`.`name`,`bible_terms`.`slug` as slug FROM `bible_terms` left join `bible_term_taxonomy` on `bible_terms`.`term_id` = `bible_term_taxonomy`.`term_id` where `bible_term_taxonomy`.`parent`='4'";
			$categories	= $wpdb->get_results($query);
		?>
		<?php if(!empty($categories)):?>
			<ul class="kjv-categories">
				<?php foreach($categories as $category):?>
					<li><a href="<?php echo $category->slug?>"><?php echo $category->name;?></a></li>
				<?php endforeach;?>
			</ul>
		<?php else : ?>
			<?php get_template_part( 'content', 'none' ); ?>
		<?php endif; ?>

		</div><!-- #content -->
	</section><!-- #primary -->

<?php //get_sidebar(); ?>
<?php get_footer(); ?>