<?php
/**
 * The Header template for our theme
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
 error_reporting(0);
?><!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->

<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri();?>/css/dropmenu.css">
<link href='http://fonts.googleapis.com/css?family=Merriweather:400,700' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Paprika' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Merienda+One' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Oswald' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Kaushan+Script' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Belleza' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Cinzel+Decorative' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Marko+One' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Permanent+Marker' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Special+Elite' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Cambay:400,700' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Cagliostro' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Strait' rel='stylesheet' type='text/css'>

<?php // Loads HTML5 JavaScript file to add support for HTML5 elements in older IE versions. ?>
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
<![endif]-->
<link rel="stylesheet" href="http://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css">
 <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
 <link href='<?php echo get_template_directory_uri(); ?>/css/font-awesome.min.css' rel='stylesheet' type='text/css'>
 <link href='<?php echo get_template_directory_uri(); ?>/css/animate.css' rel='stylesheet' type='text/css'>
 

 
<?php wp_head(); ?>
</head>
<?php 
global $bible_theme_color,$theme_color;
$bible_theme_color = $_COOKIE['theme_color']; 
if($bible_theme_color == 'water'):
$theme_color="watertheme";
else:
$theme_color="";
endif;
global $bible_font_style,$font_style;
$bible_font_style = $_COOKIE['font_style']; 
global $bible_font_size,$line_height;
$bible_font_size = ($_COOKIE['font_size']? $_COOKIE['font_size'] : "12px"); 
if($bible_font_style == 'font-merriweather'):
	$font_style="'Merriweather', serif";
elseif($bible_font_style == 'font-paprika'):
	$font_style="Paprika";
elseif($bible_font_style == 'font-meriendaone'):
	$font_style="'Merienda One', serif";
elseif($bible_font_style == 'font-oswald'):
	$font_style="Oswald";
elseif($bible_font_style == 'font-kaushanscript'):
	$font_style="'Kaushan Script', serif";
elseif($bible_font_style == 'font-belleza'):
	$font_style="'Belleza', serif";
elseif($bible_font_style == 'font-cinzeldecorative'):
	$font_style="'Cinzel Decorative', sans-serif";
elseif($bible_font_style == 'font-georgia'):
	$font_style="Georgia";
elseif($bible_font_style == 'font-verdana'):
	$font_style="Verdana";
elseif($bible_font_style == 'font-markoone'):
	$font_style="'Marko One', serif";
elseif($bible_font_style == 'font-permanentmarker'):
	$font_style="Permanent Marker";
elseif($bible_font_style == 'font-cambay'):
	$font_style="Cambay";
elseif($bible_font_style == 'font-cagliostro'):
	$font_style="Cagliostro";
elseif($bible_font_style == 'font-strait'):
	$font_style="Strait";
elseif($bible_font_style == 'font-specialelite'):
	$font_style="Special Elite";
else:
	$font_style="Helvetica, Arial, sans-serif";
endif;
global $ch_title,$cat,$chapter,$postTitle; 
global $isChapter;
if(is_category()):
	$category_name	= single_cat_title( '', false );
	$cat			= get_cat_ID($category_name);
	if($cat==69){
		$chapter = '10';
	}
	else if($cat==71){
		$chapter		= '0';
	}
	else{
		$chapter	= '1';
	}
else: 
	//$chapter		= ($_GET['ch'] ? $_GET['ch'] : '0'); 
	$chapter		= ($wp_query->query_vars['ch'] ? $wp_query->query_vars['ch'] : '0');
	
	$isChapter = (preg_match("/-/",$chapter))?true:false;
/** suntec***/
	if($isChapter)
	{
		
		$the_slug = $chapter;
		$breakout = explode("-", $chapter);
		$chapter = $breakout[1];
		$args = array(
			'name'           => $the_slug,
			'post_type'      => 'post',
			'post_status'    => 'publish',
			'posts_per_page' => 1
			);
		$my_posts = get_posts( $args );
		if( $my_posts ) {
			
			echo '<script> jQuery(document).ready(function($){ $("#post-'.$my_posts[0]->ID.'").addClass("highlight-verse"); $("html, body").animate({ "scrollTop" : $("#post-'.$my_posts[0]->ID.'").position().top+43    });   });  </script>';	
		}


	}
/****/


	$postTitle	= $chapter;
	$ch_title		= "chapter-".$chapter;
	$ch_name		= "Chapter ".$chapter;
	//$cat			= ($_GET['cat'] ? $_GET['cat'] : '0');
	$cat			= (get_slug_catid($wp_query->query_vars['category']) ? get_slug_catid($wp_query->query_vars['category']) : '0');
endif;
if($cat==0 and $chapter==0){
	$current_cat = get_the_category();
	if($current_cat[0]->parent==4):
		$current_catid	 = $current_cat[0]->term_id;
	else:	
		$current_catid 	 = $current_cat[1]->term_id;
	endif;	
	
	$link_array	= array_reverse(explode('/',get_category_link($current_catid)));
	$qry 		= "SELECT  `bible_terms`.`term_id` AS term_id,  `bible_terms`.`name` AS name FROM  `bible_terms` LEFT JOIN  `bible_term_taxonomy` ON  `bible_terms`.`term_id` =  `bible_term_taxonomy`.`term_id` WHERE  `bible_term_taxonomy`.`parent` =  '4' and `bible_terms`.`slug` = '".$link_array[1]."' ";
	$result 	= $wpdb->get_results($qry);
	$pre_cat	= $result[0]->term_id;
	
	
	$actual_link 	= "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	$link_array 	= array_reverse(explode('/',$actual_link)); 
	$chap_cat_array	= explode('-',$link_array[1]);
	$pre_chapter 	= $chap_cat_array[1];
}
if($isChapter === true):
	$str_chapter = $bible_chapter = get_post_meta( get_post_idby_slug($postTitle), 'bible_chapter', true );
	$chapter	= substr($str_chapter,(strrpos($str_chapter,'-')+1)); 
endif;
?>
<body <?php body_class($theme_color);?>>
	<div id="page" class="hfeed site">
	<header id="masthead" class="site-header" role="banner">
		
        <div class="fixed-width">
        <hgroup>
			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
			<h2 class="site-description"><?php //bloginfo( 'description' ); ?></h2>
		</hgroup>
        
		<div class="floatMenu">
		<nav id="site-navigation" class="main-navigation" role="navigation">
			<h3 class="menu-toggle"><?php _e( 'Menu', 'twentytwelve' ); ?></h3>
			<a class="assistive-text" href="#content" title="<?php esc_attr_e( 'Skip to content', 'twentytwelve' ); ?>"><?php _e( 'Skip to content', 'twentytwelve' ); ?></a>
			<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) ); ?>
	
  	</nav><!-- #site-navigation -->
        <div style="position: absolute; top: 0; margin:0 auto;">
		<!--Menu Book Chapter-->
        <div id="menu_book_chapter" class="dynamic_menu" style="left:80px; top:-20px; display: none;">
			<!--<div class="mobile">
				<div class="reader_modal_header">
					<nav>
						<a class="close_btn reference_close_btn">X</a>
					</nav>
				</div>
				<div class="tab_navigation ref">
					<div class="inner_wrapper">
						<a href="#book" class="book selected">
							<span title="translation missing: en.Book" class="translation_missing">Book</span>
						</a>
						<a href="#chapter" class="chapter">
							<span title="translation missing: en.Chapter" class="translation_missing">Chapter</span>
						</a>
					</div>
				</div>
			</div>-->
			<!--<br class="clear">-->
			<div style="display: none;" class="spinner_wrapper">
				<div id="book_chapter_spinner" class="dynamic_menu_spinner"></div>
			</div>
			<div class="browse">
				<span class="menu_arrow">
					&nbsp;
				</span>
                <header>
					<?php if($bible_theme_color == 'water'):?>
						<img class="water-theme-image" src="<?php echo  get_template_directory_uri();?>/images/drop-header-water.jpg">
						<img class="fire-theme-image" src="<?php echo  get_template_directory_uri();?>/images/drop-header-fire.jpg" style="display:none;">
					<?php else: ?>
						<img class="water-theme-image" src="<?php echo  get_template_directory_uri();?>/images/drop-header-water.jpg" style="display:none">
						<img class="fire-theme-image" src="<?php echo  get_template_directory_uri();?>/images/drop-header-fire.jpg">
					<?php endif;?>	
				</header>
				<div id="menu_book">
					<!--<header>
						Book
					</header>-->
					<div class="scroll">
						<ul class="books">
							<?php
								global $wpdb;
								$query = "SELECT `bible_terms`.`term_id` as term_id,`bible_terms`.`name` as name FROM `bible_terms` left join `bible_term_taxonomy` on `bible_terms`.`term_id` = `bible_term_taxonomy`.`term_id` where `bible_term_taxonomy`.`parent`='4'";
								$categories	= $wpdb->get_results($query);
								$active="";
								if($categories):?>
									<?php foreach($categories as $category):?>
									<li data-meta="<?php echo $category->name;?>">
										<?php if(($cat == $category->term_id) or ($category->term_id==$pre_cat)):?>
												<?php $active="active";?>
										<?php else:?>
												<?php $active="";?>
										<?php endif; ?>
										<a href="javascript:void(0)" data-book="<?php echo $category->term_id;?>"class="<?php echo $active;?>"><?php echo $category->name;?></a>
									</li>
								<?php endforeach;?>
							<?php endif;?>
						</ul>
					</div>
				</div>
				<div id="menu_chapter">
					<!--<header>
						Chapter
					</header>-->
					<div class="scroll">
					<?php
						global $arr_last_chap,$arr_cats,$arr_first_chap;
						$display="";
						$index=0;
						foreach($categories as $category):
							$cat_id = $category->term_id;
							$query = "SELECT chapter FROM `bible_chapter` 
							WHERE `category_id` = $cat_id order by id";
							$chapter_arr	= array();
							$chapter_arr	= $wpdb->get_results($query);
							$counter		= 0;
							$arr_cats[$index]=$cat_id;
							echo '<ol id="chapter_selector_'.$category->term_id .'">';
								foreach($chapter_arr as $chap):?>
									<?php $chap_ary = array_reverse(explode('-', $chap->chapter)); ?>	
									<?php $chap_id 	= $chap_ary[0]; ?>
									<?php $chap_pos	= strripos($chap->chapter,"-",0);?>
									<?php $chapt	= substr($chap->chapter,$chap_pos+1);?>
									<?php if($counter==0):?>
										<?php $arr_first_chap[$cat_id]=$chapt;?>
									<?php endif;?>
									<?php $counter++;?>
									<?php if(($chapter == $chapt && $cat == $cat_id) or ($chap_id==$pre_chapter)):?>
												<?php $active="active";?>
										<?php else:?>
												<?php $active="";?>
										<?php endif; ?>
									<li class=" canonical">
										<a href="<?php echo get_permalink(36823).get_cat_slug($cat_id)."/".$chapt;?>" class="<?php echo $active;?>"><?php echo $chapt;?></a>
									</li>
								<?php
								endforeach;
							echo '</ol>';
							$arr_last_chap[$category->term_id]=$chapt;
							$index++;
						endforeach;
					?>	
					</div>
				</div>
			</div>
		</div>
		<!--#Menu Book Chapter-->
		
		<!--Menu Dozen-->
		<div style="display: none;" id="menu_dozen" data-link-needs-param="false" class="menu-other menu_dozen dynamic_menu version_select">
			<div class="mobile">
				<div class="reader_modal_header">
					<nav>
						<a class="close_btn version_close_btn"></a>
					</nav>
				</div>
			</div>
			<div style="display: none;" class="spinner_wrapper">
				<div id="version_spinner" class="dynamic_menu_spinner"></div>
			</div>
			<div class="browse">
				<span class="menu_arrow">&nbsp;</span>
				<ul class="dozen other">
					<?php
					$categories = wp_get_nav_menu_items( 'tribes');
					foreach($categories as $category): ?>
						<li data-meta="<?php echo $category->title; ?>">
							<a href="<?php echo $category->url; ?>" data-book=""><?php echo $category->title; ?></a>
						</li>
					<?php endforeach; ?>
				</ul>
			</div>
		</div>
		<!--#Menu Dozen-->
		
		<!--Menu Truth-->
		<div style="left:270px ;top:-2px; display:none;" id="menu_truth" data-link-needs-param="false" class="menu_truth menu-other dynamic_menu version_select">
			<div class="mobile">
				<div class="reader_modal_header">
					<nav>
						<a class="close_btn version_close_btn"></a>
					</nav>
				</div>
			</div>
			<div style="display: none;" class="spinner_wrapper">
				<div id="version_spinner" class="dynamic_menu_spinner"></div>
			</div>
			<div class="browse">
				<span class="menu_arrow">&nbsp;</span>
				<ul class="other">
					<?php
					$categories = wp_get_nav_menu_items( 'basics');
					foreach($categories as $category): ?>
						<li data-meta="<?php echo $category->title; ?>">
							<a href="<?php echo $category->url; ?>" data-book=""><?php echo $category->title; ?></a>
						</li>
					<?php endforeach; ?>
				</ul>
			</div>
		</div>
		<!--#Menu Truth-->
		
		<!--Menu Falsehoods-->
		<div style="left:400px; top:-2px; display: none;" id="menu_falsehoods" data-link-needs-param="false" class="menu_falsehoods menu-other dynamic_menu version_select">
			<div class="mobile">
				<div class="reader_modal_header">
					<nav>
						<a class="close_btn version_close_btn"></a>
					</nav>
				</div>
			</div>
			<div style="display: none;" class="spinner_wrapper">
				<div id="version_spinner" class="dynamic_menu_spinner"></div>
			</div>
			<div class="browse">
				<span class="menu_arrow">&nbsp;</span>
				<ul class="other">
					<?php
					$categories = wp_get_nav_menu_items( 'strong-holds');
					foreach($categories as $category): ?>
						<li data-meta="<?php echo $category->title; ?>">
							<a href="<?php echo $category->url; ?>" data-book=""><?php echo $category->title; ?></a>
						</li>
					<?php endforeach; ?>
				</ul>
			</div>
		</div>
		<!--#Menu Falsehoods-->
		
		<!--Menu Other-->
		<div style="display: none;" data-link-needs-param="false" class="dynamic_menu version_select menu-other">
			
		</div>
		<!--#Menu Other-->
	</div>
        </div>
		<!--Search Form-->
        <div class="Searchform">
		
    <form role="search" method="get" id="searchform" class="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<div>
		<label class="screen-reader-text" for="s"><?php _x( 'Search for:', 'label' ); ?></label>
		<input type="text" value="<?php echo get_search_query(); ?>" name="s" id="s" />
		<input type="submit" id="searchsubmit" value="<?php echo esc_attr_x( 'Search', 'submit button' ); ?>" />
	</div>
</form>
    </div>
    
    <div class="setting-icon">
		<a href="#" data-toggle="modal" data-target="#setting-modal"><img src='<?php echo get_template_directory_uri(); ?>/images/setting-icon.png'></a>
    </div>
     
        
        </div>
        <?php if ( get_header_image() ) : ?>
		<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php header_image(); ?>" class="header-image" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt="" /></a>
		<?php endif; ?>
	</header><!-- #masthead -->
	
	<div id="main" class="wrapper">
		<div class="breadcrumbs" style="font-family:<?php echo $font_style;?>;font-size:14px;">
			<?php if($chapter=="0" && get_cat_parent($cat)!=4 && !is_home() && !is_single()):?>
				<?php if(function_exists('bcn_display'))
				{
					bcn_display();
				}?>
			<?php elseif(is_category()&& !is_category('word')):?>
				<span typeof="v:Breadcrumb">
					<a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
				</span>
				&gt; 
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_permalink(36823);?>" title="Go to <?php echo get_cat_name(4);?>." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
				</span>
				&gt;
				<span typeof="v:Breadcrumb">
					<?php echo get_cat_name($cat);?>
				</span> 
			<?php elseif(is_page('word')&& ($isChapter === true)):?>
				<span typeof="v:Breadcrumb">
					<a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
				</span>
				&gt; 
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_permalink(36823);?>" title="Go to <?php echo get_cat_name(4);?>." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
				</span>
				&gt;
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_category_link($cat);?>" title="Go to <?php echo get_cat_name($cat);?>." property="v:title" rel="v:url"><?php echo get_cat_name($cat);?></a>
				</span> 
				&gt; 
				<span typeof="v:Breadcrumb"><span property="v:title" class="post-title"><?php echo get_post_title_by_slug($postTitle);?></span></span>
			<?php elseif(!is_home()&& $chapter=="0" && $cat!=0 && (is_page('word'))):?>
				<span typeof="v:Breadcrumb">
					<a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
				</span>
				&gt; 
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_permalink(36823);?>" title="Go to <?php echo get_cat_name(4);?>." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
				</span>
				&gt;
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_category_link($cat);?>" title="Go to <?php echo get_cat_name($cat);?>." property="v:title" rel="v:url"><?php echo get_cat_name($cat);?></a>
				</span> 
				&gt; 
				<span typeof="v:Breadcrumb"><span property="v:title" class="chapter-title">Introduction</span></span>
			<?php elseif(is_category('word')):?>
				<span typeof="v:Breadcrumb">
					<a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
				</span>
				&gt; 
				<span typeof="v:Breadcrumb">
					<?php echo get_cat_name(4);?>
				</span>
			<?php elseif(!is_home()&& $chapter!="0"):?>
				<span typeof="v:Breadcrumb">
					<a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
				</span>
				&gt; 
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_permalink(36823);?>" title="Go to <?php echo get_cat_name(4);?>." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
				</span>
				&gt;
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_category_link($cat);?>" title="Go to <?php echo get_cat_name($cat);?>." property="v:title" rel="v:url"><?php echo get_cat_name($cat);?></a>
				</span> 
				&gt; 
				<span typeof="v:Breadcrumb"><span property="v:title" class="chapter-title"><?php echo $ch_name;?></span></span>
			<?php elseif(!is_home()&& $chapter=="0" && $cat!=0 && (is_page('word'))):?>
				<span typeof="v:Breadcrumb">
					<a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
				</span>
				&gt; 
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_permalink(36823);?>" title="Go to <?php echo get_cat_name(4);?>." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
				</span>
				&gt;
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_category_link($cat);?>" title="Go to <?php echo get_cat_name($cat);?>." property="v:title" rel="v:url"><?php echo get_cat_name($cat);?></a>
				</span> 
				&gt; 
				<span typeof="v:Breadcrumb"><span property="v:title" class="chapter-title">Introduction</span></span>
			<?php elseif(is_single()):?>
				<span typeof="v:Breadcrumb">
					<a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
				</span>
				&gt; 
				<span typeof="v:Breadcrumb">
					<a class="taxonomy category" href="<?php echo get_permalink(36823);?>" title="Go to <?php echo get_cat_name(4);?>." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
				</span>
				&gt;
				<span typeof="v:Breadcrumb">
					<?php $current_cat = get_the_category();
						if($current_cat[0]->parent==4):
							$current_catname = $current_cat[0]->name;
							$current_catid	 = $current_cat[0]->term_id;
						else:	
							$current_catname = $current_cat[1]->name;
							$current_catid 	 = $current_cat[1]->term_id;
						endif;
						?>
					<a class="taxonomy category" href="<?php echo get_category_link($current_catid);?>" title="Go to <?php echo $current_catname;?>." property="v:title" rel="v:url"><?php echo $current_catname;?></a>
				</span> 
				&gt; 
				<span typeof="v:Breadcrumb"><span property="v:title" class="chapter-title"><?php echo get_post_meta(get_the_ID(),'_subtitle',true);?></span></span>
			<?php endif;?>
		</div>