<?php

/**

 * The Header template for our theme

 *

 * Displays all of the <head> section and everything up till <div id="main">

 *

 * @package WordPress

 * @subpackage Twenty_Twelve

 * @since Twenty Twelve 1.0

 */

 error_reporting(0);

 function setBibleThemeImage($bible_theme_color,$context){
 	$themeArrayList = array("water","tree","fire","space","wood","stone","gold","king","chariot","seal","egypt","red");
 	foreach($themeArrayList as $key =>$value){
 		$displayStr= ' style="display:none;" ';
 		if((empty($bible_theme_color) && $value=='fire') || $value == $bible_theme_color){
 		    $displayStr= "";
 		}

 		echo '<img class="'.$value.'-theme-image" src="'.get_template_directory_uri().'/images/drop-header-'.$context.'-'.$value.'.png" '.$displayStr.' />';	
 	}
 }

?>
<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri();?>/css/dropmenu.css">
<link href='https://fonts.googleapis.com/css?family=Merienda+One' rel='stylesheet' type='text/css'>
<link href='https://fonts.googleapis.com/css?family=Oswald' rel='stylesheet' type='text/css'>
<link href='https://fonts.googleapis.com/css?family=Cinzel+Decorative' rel='stylesheet' type='text/css'>
<link href='https://fonts.googleapis.com/css?family=Marko+One' rel='stylesheet' type='text/css'>
<link href='https://fonts.googleapis.com/css?family=Permanent+Marker' rel='stylesheet' type='text/css'>
<link href='https://fonts.googleapis.com/css?family=Special+Elite' rel='stylesheet' type='text/css'>
<link href='https://fonts.googleapis.com/css?family=Cagliostro' rel='stylesheet' type='text/css'>

<?php // Loads HTML5 JavaScript file to add support for HTML5 elements in older IE versions. ?>

<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
<![endif]-->
<link rel="stylesheet" href="http://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css">
<link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
<link href='<?php echo get_template_directory_uri(); ?>/css/font-awesome.min.css' rel='stylesheet' type='text/css'>
<link href='<?php echo get_template_directory_uri(); ?>/css/animate.css' rel='stylesheet' type='text/css'>

<?php wp_head(); ?>

</head>

<?php 

global $bible_theme_color,$theme_color;
$bible_theme_color = $_COOKIE['theme_color'];

if($bible_theme_color == 'water'){
    $theme_color="watertheme";
}elseif($bible_theme_color == 'tree'){
    $theme_color="treetheme";
}elseif($bible_theme_color == 'space'){
    $theme_color="spacetheme";
}elseif($bible_theme_color == 'wood'){
    $theme_color="woodtheme";
}elseif($bible_theme_color == 'stone'){
    $theme_color="stonetheme";
}elseif($bible_theme_color == 'gold'){
    $theme_color="goldtheme";
}elseif($bible_theme_color == 'king'){
    $theme_color="kingtheme";
}elseif($bible_theme_color == 'chariot'){
    $theme_color="chariottheme";
}elseif($bible_theme_color == 'seal'){
    $theme_color="sealtheme";
}elseif($bible_theme_color == 'egypt'){
    $theme_color="egypttheme";
}elseif($bible_theme_color == 'red'){
    $theme_color="redtheme";
}else{
    $theme_color="";
}

global $bible_font_style,$font_style,$bible_font_size,$line_height,$ch_title,$cat,$chapter,$postTitle,$isChapter;

$bible_font_style = $_COOKIE['font_style']; 
$bible_font_size = ($_COOKIE['font_size']? $_COOKIE['font_size'] : "12px");

if($bible_font_style == 'font-merriweather'){
    $font_style="'Merriweather', serif";
}elseif($bible_font_style == 'font-meriendaone'){
    $font_style="'Merienda One', serif";
}elseif($bible_font_style == 'font-oswald'){
    $font_style="Oswald";
}elseif($bible_font_style == 'font-cinzeldecorative'){
    $font_style="'Cinzel Decorative', sans-serif";
}elseif($bible_font_style == 'font-georgia'){
    $font_style="Georgia";
}elseif($bible_font_style == 'font-verdana'){
    $font_style="Verdana";
}elseif($bible_font_style == 'font-markoone'){
    $font_style="'Marko One', serif";
}elseif($bible_font_style == 'font-permanentmarker'){
    $font_style="Permanent Marker";
}elseif($bible_font_style == 'font-cagliostro'){
    $font_style="Cagliostro";
}elseif($bible_font_style == 'font-specialelite'){
    $font_style="Special Elite";
}else{
    $font_style="Helvetica, Arial, sans-serif";
}

if(is_category()){

	$category_name	= single_cat_title( '', false );
	$cat			= get_cat_ID($category_name);

	if($cat==69){
		$chapter = '10';
	}elseif($cat==71){
		$chapter = '0';
	}else{
		$chapter = '1';
	}

}else {

    $chapter = ($wp_query->query_vars['ch'] ? $wp_query->query_vars['ch'] : '0');
    $isChapter = (preg_match("/-/", $chapter)) ? true : false;

    /** suntec***/

    if (!$isChapter && isset($_GET['v'])) {

        global $global_chapter;

        $the_slug = $_GET['v'];

        $args = array(
            'name' => $the_slug,
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => 1
        );

        $my_posts = get_posts($args);

        if ($my_posts) {
            echo '<script> jQuery(document).ready(function($){ $("#post-' . $my_posts[0]->ID . '").addClass("highlight-verse"); $("html, body").animate({ "scrollTop" : $("#post-' . $my_posts[0]->ID . '").position().top+43    });   });  </script>';
        }
    }

    /****/

    /**
     * symatic
     */
    $args = array(
        'name' => $chapter,
        'post_type' => 'post',
        'post_status' => 'publish',
        'posts_per_page' => 1
    );

    $post = get_posts($args);
    $cats = wp_get_post_categories($post[0]->ID);
    $cateid = get_site_option('symatic_strong_cat');
    $isStrong = in_array($cateid, $cats);
    $postTitle = $chapter;
    $ch_title = "chapter-" . $chapter;
    $ch_name = $isStrong ? $chapter : "Chapter " . $chapter;
    /*$post =*/

    //$cat			= ($_GET['cat'] ? $_GET['cat'] : '0');

    $cat = (get_slug_catid($wp_query->query_vars['category']) ? get_slug_catid($wp_query->query_vars['category']) : '0');
}

if($cat==0 and $chapter==0){
	$current_cat = get_the_category();

	if($current_cat[0]->parent==4) {
        $current_catid = $current_cat[0]->term_id;
    }else{
	    $current_catid 	 = $current_cat[1]->term_id;
    }

	$link_array	= array_reverse(explode('/',get_category_link($current_catid)));
	$qry 		= "SELECT  `bible_terms`.`term_id` AS term_id,  `bible_terms`.`name` AS name FROM  `bible_terms` LEFT JOIN  `bible_term_taxonomy` ON  `bible_terms`.`term_id` =  `bible_term_taxonomy`.`term_id` WHERE  `bible_term_taxonomy`.`parent` =  '4' and `bible_terms`.`slug` = '".$link_array[1]."' ";
	$result 	= $wpdb->get_results($qry);
	$pre_cat	= $result[0]->term_id;
	$actual_link 	= "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	$link_array 	= array_reverse(explode('/',$actual_link));
	$chap_cat_array	= explode('-',$link_array[1]);
	$pre_chapter 	= $chap_cat_array[1];
}

if($isChapter === true) {
    $str_chapter = $bible_chapter = get_post_meta(get_post_idby_slug($postTitle), 'bible_chapter', true);
    $chapter = substr($str_chapter, (strrpos($str_chapter, '-') + 1));
}

?>

<body <?php body_class($theme_color);?>>
	<div id="page" class="hfeed site">
	<header id="masthead" class="site-header" role="banner">
        <div class="fixed-width">
        <hgroup>
			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
			<h2 class="site-description"><?php //bloginfo( 'description' ); ?></h2>
		</hgroup>

		<div class="floatMenu">
		    <nav id="site-navigation" class="main-navigation" role="navigation">
			    <h3 class="menu-toggle"><?php _e( 'Menu', 'twentytwelve' ); ?></h3>
			    <a class="assistive-text" href="#content" title="<?php esc_attr_e( 'Skip to content', 'twentytwelve' ); ?>"><?php _e( 'Skip to content', 'twentytwelve' ); ?></a>
			    <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) ); ?>
  	        </nav><!-- #site-navigation -->

            <div style="position: absolute; top: 0; margin:0 auto;">
		        <!--Menu Book Chapter-->
                <div id="menu_book_chapter" class="dynamic_menu" style="left:50px; top:23px; display: none;">

                <!--<br class="clear">-->
                <div style="display: none;" class="spinner_wrapper">
                    <div id="book_chapter_spinner" class="dynamic_menu_spinner"></div>
                </div>

			    <div class="browse">
				    <span class="menu_arrow"></span>
                    <header><?php setBibleThemeImage($bible_theme_color,"book"); ?></header>
				    <div id="menu_book">
					    <div class="scroll">
						    <ul class="books">
							    <?php
								    global $wpdb;

								    $query = "SELECT `bible_terms`.`term_id` as term_id,`bible_terms`.`name` as name FROM `bible_terms` left join `bible_term_taxonomy` on `bible_terms`.`term_id` = `bible_term_taxonomy`.`term_id` where `bible_term_taxonomy`.`parent`='4'";
								    $categories	= $wpdb->get_results($query);
								    $active="";
								    $cateid = get_site_option('symatic_strong_cat');

								    if($categories){
                                        foreach($categories as $category){
                                            if($category->term_id == $cateid) continue;
                                ?>

									        <li data-meta="<?php echo $category->name;?>">

										    <?php
                                                if(($cat == $category->term_id) or ($category->term_id==$pre_cat)){
                                                    $active="active";
                                                }else{
                                                    $active="";
                                                }?>

										<a href="javascript:void(0)" data-book="<?php echo $category->term_id;?>"class="<?php echo $active;?>"><?php echo $category->name;?></a>

									</li>

								<?php }
								    } ?>
						</ul>
					</div>
				</div>

				<div id="menu_chapter">
					<div class="scroll">

					<?php

						global $arr_last_chap,$arr_cats,$arr_first_chap;

						$display="";
						$index=0;

						foreach($categories as $category):

							$cat_id = $category->term_id;
							$query = "SELECT chapter FROM `bible_chapter` 
							WHERE `category_id` = $cat_id order by id";

							$chapter_arr	= array();
							$chapter_arr	= $wpdb->get_results($query);

							$counter		= 0;
							$arr_cats[$index]=$cat_id;
                            $newchapt = $chapt = 0;

							echo '<ol id="chapter_selector_'.$category->term_id .'">';

								foreach($chapter_arr as $chap):
                                    $chap_ary = array_reverse(explode('-', $chap->chapter));
								    $chap_id 	= $chap_ary[0];
								    $chap_pos	= strripos($chap->chapter,"-",0);
								    $newchapt = substr($chap->chapter,$chap_pos+1);
								    if($newchapt < $chapt) continue;
								    $chapt	= $newchapt;

								    if($counter == 0){
								        $arr_first_chap[$cat_id]=$chapt;
                                    }
								    $counter++;

								    if(($chapter == $chapt && $cat == $cat_id) or ($chap_id==$pre_chapter)){
								        $active="active";
                                    }else{
								        $active="";
                                    }
								    ?>

									<li class="canonical">
										<a href="<?php echo get_permalink(36823).get_cat_slug($cat_id)."/".$chapt;?>" class="<?php echo $active;?>">
                                            <?php echo $chapt;?>
                                        </a>
									</li>

								<?php

								endforeach;

							echo '</ol>';

							$arr_last_chap[$category->term_id]=$chapt;
							$index++;

						endforeach;

					?>	

					</div>
				</div>
			</div>
		</div>
		<!--#Menu Book Chapter-->

		<!--Menu Dozen-->
		<div style="display: none;" id="menu_dozen" data-link-needs-param="false" class="menu-other menu_dozen dynamic_menu version_select">
			<div class="mobile">
				<div class="reader_modal_header">
					<nav>
						<a class="close_btn version_close_btn"></a>
					</nav>
				</div>
			</div>

			<div style="display: none;" class="spinner_wrapper">
				<div id="version_spinner" class="dynamic_menu_spinner"></div>
			</div>

			<div class="browse">
				<span class="menu_arrow">&nbsp;</span>
				<header>
					<?php if($bible_theme_color == 'water'):?>
						<img class="water-theme-image" src="<?php echo  get_template_directory_uri();?>/images/drop-header-water.jpg">
						<img class="fire-theme-image" src="<?php echo  get_template_directory_uri();?>/images/drop-header-fire.jpg" style="display:none;">
					<?php else: ?>
						<img class="water-theme-image" src="<?php echo  get_template_directory_uri();?>/images/drop-header-water.jpg" style="display:none">
						<img class="fire-theme-image" src="<?php echo  get_template_directory_uri();?>/images/drop-header-fire.jpg">
					<?php endif;?>
				</header>

				<ul class="dozen other">
					<?php
					$categories = wp_get_nav_menu_items( 'tribes');
					foreach($categories as $category): ?>
						<li data-meta="<?php echo $category->title; ?>">
							<a href="<?php echo $category->url; ?>" data-book=""><?php echo $category->title; ?></a>
						</li>
					<?php endforeach; ?>
				</ul>
			</div>
		</div>
		<!--#Menu Dozen-->

		<!--Menu Truth-->
		<div style="left:50px ;top:23px; display:none;" id="menu_truth" data-link-needs-param="false" class="menu_truth menu-other dynamic_menu version_select">
			<div class="mobile">
				<div class="reader_modal_header">
					<nav>
						<a class="close_btn version_close_btn"></a>
					</nav>
				</div>
			</div>

			<div style="display: none;" class="spinner_wrapper">
				<div id="version_spinner" class="dynamic_menu_spinner"></div>
			</div>

			<div class="browse">
				<span class="menu_arrow">&nbsp;</span>
				<header>
					<?php setBibleThemeImage($bible_theme_color,"law"); ?>
				</header>

				<div class="scroll">

                    <ul class="other">

                        <?php
                        $categories = wp_get_nav_menu_items( 'basics');

                        foreach($categories as $category): ?>
                            <li data-meta="<?php echo $category->title; ?>">
                                <a href="<?php echo $category->url; ?>" data-book=""><?php echo $category->title; ?></a>
                            </li>
                        <?php endforeach; ?>

                    </ul>
				</div>
			</div>
		</div>
		<!--#Menu Truth-->

		<!--Menu Falsehoods-->
		<div style="left:50px; top:23px; display: none;" id="menu_falsehoods" data-link-needs-param="false" class="menu_falsehoods menu-other dynamic_menu version_select">
			<div class="mobile">
				<div class="reader_modal_header">
					<nav>
						<a class="close_btn version_close_btn"></a>
					</nav>
				</div>
			</div>

			<div style="display: none;" class="spinner_wrapper">
				<div id="version_spinner" class="dynamic_menu_spinner"></div>
			</div>

			<div class="browse">
				<span class="menu_arrow">&nbsp;</span>
				<header>
					<?php setBibleThemeImage($bible_theme_color,"precept"); ?>
				</header>

				<div class="scroll">
                    <ul class="other">
                        <?php
                        $categories = wp_get_nav_menu_items( 'strong-holds');
                        foreach($categories as $category): ?>
                            <li data-meta="<?php echo $category->title; ?>">
                                <a href="<?php echo $category->url; ?>" data-book=""><?php echo $category->title; ?></a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
				</div>
			</div>
		</div>
		<!--#Menu Falsehoods-->

		<!-- Settings -->
		<div style="left:50px; top:23px; display: none;" id="settings" data-link-needs-param="false" class="settings menu-other dynamic_menu version_select">
			<div class="mobile">
				<div class="reader_modal_header">
					<nav>
						<a class="close_btn version_close_btn"></a>
					</nav>
				</div>
			</div>

			<div style="display: none;" class="spinner_wrapper">
				<div id="version_spinner" class="dynamic_menu_spinner"></div>
			</div>

			<div class="browse">
				<span class="menu_arrow">&nbsp;</span>
				<header>
					<?php setBibleThemeImage($bible_theme_color,"settings"); ?>
				</header>
                <div class="scroll">
                    <!--Theme-Color-->
                    <img class="theme-setting" src="<?php echo  get_template_directory_uri();?>/images/settings-themes.gif">

                    <div class="font-style-buttons">
                        <?php $bible_theme_color = ($_COOKIE['theme_color'] ? $_COOKIE['theme_color']:"fire"); ?>
                        <div class="radio">
                            <label>
                                <input type="radio" name="theme_color" class="bible_radio radio-theme-fire" value="fire" <?php if($bible_theme_color=="fire"){echo "checked";}?>>Consuming Fire
                            </label>
                        </div>

                        <div class="radio">
                            <label>
                                <input type="radio" name="theme_color" class="bible_radio radio-theme-water" value="water" <?php if($bible_theme_color=="water"){echo "checked";}?> >Living Water
                            </label>
                        </div>

                        <div class="radio">
                            <label>
                                <input type="radio" name="theme_color" class="bible_radio radio-theme-water" value="tree" <?php if($bible_theme_color=="tree"){echo "checked";}?> >Tree of Life
                            </label>
                        </div>

                        <div class="radio">
                            <label>
                                <input type="radio" name="theme_color" class="bible_radio radio-theme-water" value="space" <?php if($bible_theme_color=="space"){echo "checked";}?> >Many Mansions
                            </label>
                        </div>

                        <div class="radio">
                            <label>
                                <input type="radio" name="theme_color" class="bible_radio radio-theme-water" value="wood" <?php if($bible_theme_color=="wood"){echo "checked";}?> >Shittim Wood
                            </label>
                        </div>

                        <div class="radio">
                            <label>
                                <input type="radio" name="theme_color" class="bible_radio radio-theme-water" value="red" <?php if($bible_theme_color=="red"){echo "checked";}?> >7 Candlesticks
                            </label>
                        </div>

                        <div class="radio">
                            <label>
                                <input type="radio" name="theme_color" class="bible_radio radio-theme-water" value="chariot" <?php if($bible_theme_color=="chariot"){echo "checked";}?> >Chariots
                            </label>
                        </div>

                        <div class="radio">
                            <label>
                                <input type="radio" name="theme_color" class="bible_radio radio-theme-water" value="stone" <?php if($bible_theme_color=="stone"){echo "checked";}?> >Tables of Stone
                            </label>
                        </div>

                        <div class="radio">
                            <label>
                                <input type="radio" name="theme_color" class="bible_radio radio-theme-water" value="king" <?php if($bible_theme_color=="king"){echo "checked";}?> >King of Kings
                            </label>
                        </div>

                        <div class="radio">
                            <label>
                                <input type="radio" name="theme_color" class="bible_radio radio-theme-water" value="gold" <?php if($bible_theme_color=="gold"){echo "checked";}?> >Streets of Gold
                            </label>
                        </div>

                        <div class="radio">
                            <label>
                                <input type="radio" name="theme_color" class="bible_radio radio-theme-water" value="seal" <?php if($bible_theme_color=="seal"){echo "checked";}?> >Seal the Book
                            </label>
                        </div>

                        <div class="radio">
                            <label>
                                <input type="radio" name="theme_color" class="bible_radio radio-theme-water" value="egypt" <?php if($bible_theme_color=="egypt"){echo "checked";}?> >Egypt Again
                            </label>
                        </div>
                    </div>
					<!--#Theme-Color-->

					<!--Font-Size-->
					<div class="text_size">

						<?php $bible_font_size = ($_COOKIE['font_size']? $_COOKIE['font_size'] : "12px");?>

						<img class="theme-fonts" src="<?php echo  get_template_directory_uri();?>/images/settings-text_size.gif">

						<div class="font-control-buttons">
							<div class="radio">
								<label>
									<input type="radio" class="bible_radio radio-font-xs" name="size_options" id="option1" value="12px" <?php if($bible_font_size=="12px"){echo "checked";}?>>S
								</label>
							</div>
							<div class="radio">
								<label>
									<input type="radio" class="bible_radio radio-font-small" name="size_options" id="option2" value="16px" <?php if($bible_font_size=="16px"){echo "checked";}?>>M
								</label>
							</div>
							<div class="radio">
								<label>
									<input type="radio" class="bible_radio radio-font-medium" name="size_options" id="option3" value="18px" <?php if($bible_font_size=="18px"){echo "checked";}?>>L
								</label>
							</div>

							<div class="radio">
								<label>
									<input type="radio" class="bible_radio radio-font-large" name="size_options" id="option4" value="22px" <?php if($bible_font_size=="22px"){echo "checked";}?>>XL
								</label>
							</div>

							<div class="radio">
								<label>
									<input type="radio" class="bible_radio radio-font-large" name="size_options" id="option5" value="26px" <?php if($bible_font_size=="26px"){echo "checked";}?>>XXL
								</label>
							</div>
						</div>
					    <!--#Font-Size-->
					</div>
					<!--Font Type-->

					<div class="font-style">
						<img class="theme-font-type" src="<?php echo  get_template_directory_uri();?>/images/settings-font_type.gif">
						<div class="verse-control-buttons">
							<?php $bible_font_style = ($_COOKIE['font_style']? $_COOKIE['font_style'] : "font-arial"); ?>
							<div class="radio">
								<label class="font-arial">
									<input type="radio" class="bible_radio radio-font-arial" name="style_options" id="option1" value="font-arial" <?php if($bible_font_style=="font-arial"){echo "checked";}?>>Arial
								</label>
							</div>
							<div class="radio">
								<label class="font-cagliostro">
									<input type="radio" class="bible_radio radio-font-cagliostro" name="style_options" id="option3" value="font-cagliostro" <?php if($bible_font_style=="font-cagliostro"){echo "checked";}?>>Prophets
								</label>
							</div>
							<div class="radio">
								<label class="font-cinzeldecorative">
									<input type="radio" class="bible_radio radio-font-cinzeldecorative" name="style_options" id="option3" value="font-cinzeldecorative" <?php if($bible_font_style=="font-cinzeldecorative"){echo "checked";}?>>Cinzel
								</label>
							</div>
							<div class="radio">
								<label class="font-georgia">
									<input type="radio" class="bible_radio radio-font-georgia" name="style_options" id="option3" value="font-georgia" <?php if($bible_font_style=="font-georgia"){echo "checked";}?>>Georgia
								</label>
							</div>
							<div class="radio">
								<label class="font-meriendaone">
									<input type="radio" class="bible_radio radio-font-meriendaone" name="style_options" id="option3" value="font-meriendaone" <?php if($bible_font_style=="font-meriendaone"){echo "checked";}?>>Epistle
								</label>
							</div>
                            <div class="radio">
								<label class="font-markoone">
									<input type="radio" class="bible_radio radio-font-markoone" name="style_options" id="option3" value="font-markoone" <?php if($bible_font_style=="font-markoone"){echo "checked";}?>>Scroll
								</label>
							</div>
							<div class="radio">
								<label class="font-oswald">
									<input type="radio" class="bible_radio radio-font-oswald" name="style_options" id="option3" value="font-oswald" <?php if($bible_font_style=="font-oswald"){echo "checked";}?>>Law
								</label>
							</div>
                            <div class="radio">
								<label class="font-permanentmarker">
									<input type="radio" class="bible_radio radio-font-permanentmarker" name="style_options" id="option3" value="font-permanentmarker" <?php if($bible_font_style=="font-permanentmarker"){echo "checked";}?>>Marker
								</label>
							</div>
     						<div class="radio">
								<label class="font-specialelite">
									<input type="radio" class="bible_radio radio-font-specialelite" name="style_options" id="option3" value="font-specialelite" <?php if($bible_font_style=="font-specialelite"){echo "checked";}?>>Typewriter
								</label>
							</div>
							<div class="radio">
								<label class="font-verdana">
									<input type="radio" class="bible_radio radio-font-verdana" name="style_options" id="option3" value="font-verdana" <?php if($bible_font_style=="font-verdana"){echo "checked";}?>>Verdana
								</label>
							</div>
						</div>
					</div>
					<!--#Fonts-->
				</div>
			</div>
		</div>
		<!-- Settings -->

		<!--Menu Other-->
		<div style="display: none;" data-link-needs-param="false" class="dynamic_menu version_select menu-other">
		</div>
		<!--#Menu Other-->

	</div>
</div>

<!--Search Form-->
<div class="Searchform">
    <form role="search" method="get" id="searchform" class="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
        <div>
            <label class="screen-reader-text" for="s"><?php _x( 'Search for:', 'label' ); ?></label>
            <input type="text" value="<?php echo get_search_query(); ?>" name="s" id="s" />
            <input type="submit" id="searchsubmit" value="<?php echo esc_attr_x( 'Search', 'submit button' ); ?>" />
        </div>
    </form>

</div>

<div class="setting-icon">
    <a href="#" data-toggle="modal" data-target="#setting-modal"><img src='<?php echo get_template_directory_uri(); ?>/images/setting-icon.png'></a>
</div>
</div>

<?php if ( get_header_image() ) : ?>

<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php header_image(); ?>" class="header-image" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt="" /></a>

<?php endif; ?>

</header><!-- #masthead -->

<?php $catname = get_cat_name($cat); ?>

<div id="main" class="wrapper">
    <div class="breadcrumbs" style="font-family:<?php echo $font_style;?>;font-size:14px;">
        <?php if($chapter=="0" && get_cat_parent($cat)!=4 && !is_home() && !is_single()):?>

            <?php if(function_exists('bcn_display')){
                bcn_display();
            }?>

        <?php elseif(is_category()&& !is_category('word')):?>

            <span typeof="v:Breadcrumb">
                <a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb">
                <a class="taxonomy category" href="<?php echo get_permalink(36823);?>" title="Go to <?php echo get_cat_name(4);?>." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb">
                <?php echo get_cat_name($cat);?>
            </span>
        <?php elseif(is_page('word')&& ($isChapter === true)):?>
            <span typeof="v:Breadcrumb">
                <a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb">
                <a class="taxonomy category" href="<?php echo get_permalink(36823);?>" title="Go to <?php echo get_cat_name(4);?>." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb">
                <a class="taxonomy category" href="<?php echo get_category_link($cat);?>" title="Go to <?php echo get_cat_name($cat);?>." property="v:title" rel="v:url"><?php echo get_cat_name($cat);?></a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb"><span property="v:title" class="post-title"><?php echo get_post_title_by_slug($postTitle);?></span></span>
        <?php elseif(!is_home()&& $chapter=="0" && $cat!=0 && (is_page('word'))):?>
            <span typeof="v:Breadcrumb">
                <a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb">
                <a class="taxonomy category" href="<?php echo get_permalink(36823);?>" title="Go to <?php echo get_cat_name(4);?>." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb">
                <a class="taxonomy category" href="<?php echo get_category_link($cat);?>" title="Go to <?php echo get_cat_name($cat);?>." property="v:title" rel="v:url"><?php echo get_cat_name($cat);?></a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb"><span property="v:title" class="chapter-title">Introduction</span></span>
        <?php elseif(is_category('word')):?>
            <span typeof="v:Breadcrumb">
                <a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb">
                <?php echo get_cat_name(4);?>
            </span>
        <?php elseif(!is_home()&& $chapter!="0"):?>
            <span typeof="v:Breadcrumb">
                <a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb">
                <a class="taxonomy category" href="<?php echo get_permalink(36823);?>" title="Go to <?php echo get_cat_name(4);?>." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
            </span>
            &gt;
            <?php if(strtolower($catname) !== strtolower($ch_name)): ?>
            <span typeof="v:Breadcrumb">
                <a class="taxonomy category" href="<?php echo get_category_link($cat);?>" title="Go to <?php echo $catname; ?>." property="v:title" rel="v:url"><?php echo get_cat_name($cat);?></a>
            </span>
            &gt;
            <?php endif; ?>
            <span typeof="v:Breadcrumb"><span property="v:title" class="chapter-title"><?php echo $ch_name;?></span></span>
        <?php elseif(!is_home()&& $chapter=="0" && $cat!=0 && (is_page('word'))):?>
            <span typeof="v:Breadcrumb">
                <a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb">
                <a class="taxonomy category" href="<?php echo get_permalink(36823);?>" title="Go to <?php echo get_cat_name(4);?>." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb">
                <a class="taxonomy category" href="<?php echo get_category_link($cat);?>" title="Go to <?php echo get_cat_name($cat);?>." property="v:title" rel="v:url"><?php echo get_cat_name($cat);?></a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb"><span property="v:title" class="chapter-title">Introduction</span></span>
        <?php elseif(is_single()):?>
            <span typeof="v:Breadcrumb">
                <a class="home" href="<?php echo home_url();?>" title="Go to Home." property="v:title" rel="v:url">Home</a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb">
                <a class="taxonomy category" href="<?php echo get_permalink(36823);?>" title="Go to <?php echo get_cat_name(4);?>." property="v:title" rel="v:url"><?php echo get_cat_name(4);?></a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb">
                <?php $current_cat = get_the_category();
                    if($current_cat[0]->parent==4):
                        $current_catname = $current_cat[0]->name;
                        $current_catid	 = $current_cat[0]->term_id;
                    else:
                        $current_catname = $current_cat[1]->name;
                        $current_catid 	 = $current_cat[1]->term_id;
                    endif;
                    ?>
                <a class="taxonomy category" href="<?php echo get_category_link($current_catid);?>" title="Go to <?php echo $current_catname;?>." property="v:title" rel="v:url"><?php echo $current_catname;?></a>
            </span>
            &gt;
            <span typeof="v:Breadcrumb"><span property="v:title" class="chapter-title"><?php echo get_post_meta(get_the_ID(),'_subtitle',true);?></span></span>
        <?php endif;?>
    </div>