<?php
/**
 * The template for displaying the footer
 *
 * Contains footer content and the closing of the #main and #page div elements.
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
?>
	</div><!-- #main .wrapper -->

	<div class="setting-form modal fade" role="dialog" id="setting-modal">
		<div class="modal-dialog">
			<!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
						<h4>Formatting</h4>
				</div>
				<div class="modal-body">
					<form name="bible_theme_options" method="post" id="bible-theme-options">
						<!--Font-Size-->
						<div class="col-xs-12 col-md-6">
							<?php $bible_font_size = get_option( 'bible_font_size' );?>
							<h3>Font Size</h3>
							<div class="font-control-buttons">
								<div class="radio">
									<label>
										<input type="radio" class="bible_font_size radio-font-xs" name="size_options" id="option1" value="12px" <?php if($bible_font_size=="12px"){echo "checked";}?>>Extra Small
									</label>
								</div>
								<div class="radio">
									<label>
										<input type="radio" class="bible_font_size radio-font-small" name="size_options" id="option2" value="14px" <?php if($bible_font_size=="14px"){echo "checked";}?>>Small
									</label>
								</div>
								<div class="radio">
									<label>
										<input type="radio" class="bible_font_size radio-font-medium" name="size_options" id="option3" value="16px" <?php if($bible_font_size=="16px"){echo "checked";}?>>Medium
									</label>
								</div>
								<div class="radio">
									<label>
										<input type="radio" class="bible_font_size radio-font-large" name="size_options" id="option4" value="18px" <?php if($bible_font_size=="18px"){echo "checked";}?>>Large
									</label>
								</div>
							</div>
						</div>
						<!--#Font-Size-->
					   
						<!--Fonts-->
						<div class="col-xs-12 col-md-6">
							<h3>Font</h3>
							<div class="font-style-buttons">
								<?php $bible_font_style = get_option( 'bible_font_style' ); ?>
								<div class="radio">
									<label class="font-arial">
										<input type="radio" class="bible_font_style radio-font-arial" name="style_options" id="option1" value="font-arial" <?php if($bible_font_style=="font-arial"){echo "checked";}?>>Arial
									</label>
								</div>
								<div class="radio">
									<label class="font-timesnewroman">
										<input type="radio" class="bible_font_style radio-font-timesnewroman" name="style_options" id="option2" value="font-timesnewroman" <?php if($bible_font_style=="font-timesnewroman"){echo "checked";}?>>Times New Roman
									</label>
								</div>
								<div class="radio">
									<label class="font-merriweather">
										<input type="radio" class="bible_font_style radio-font-merriweather" name="style_options" id="option3" value="font-merriweather" <?php if($bible_font_style=="font-merriweather"){echo "checked";}?>>Merriweather
									</label>
								</div>
							</div>
						</div>
						<div class="clearfix"></div>
						<!--#Fonts-->
						<!--Theme-Color-->
						<div class="col-xs-12">
							<h3>Theme Color </h3>
							<div class="verse-control-buttons">
								<?php $bible_theme_color = get_option( 'bible_theme_color' ); ?>
								<div class="radio">
									<label>
										<input type="radio" name="theme_color" class="theme-color radio-theme-fire" value="fire" <?php if($bible_theme_color=="fire"){echo "checked";}?>>Fire
									</label>
								</div>
								<div class="radio">
									<label>
										<input type="radio" name="theme_color" class="theme-color radio-theme-water" value="water" <?php if($bible_theme_color=="water"){echo "checked";}?> >Water
									</label>
								</div>
							</div>
						</div>
						<!--#Theme-Color-->
					</div>
					 <div class="clearfix"></div>
					<!--Footer-->
					<div class="modal-footer">
						<button type="submit" class="btn btn-default" id="save-setting">Save</button>
					</div>
					<!--#Footer-->
				</form>
			</div>
		</div>
	</div>
	
	
	<footer id="colophon" role="contentinfo">
		<div class="site-info">
        
        <?php dynamic_sidebar('footeraddress'); ?>
        <?php dynamic_sidebar('footerMenu'); ?>
        <div class="clear"></div>
			<?php //do_action( 'twentytwelve_credits' ); ?>
			<?php /*?><a href="<?php echo esc_url( __( 'http://wordpress.org/', 'twentytwelve' ) ); ?>" title="<?php esc_attr_e( 'Semantic Personal Publishing Platform', 'twentytwelve' ); ?>"><?php printf( __( 'Proudly powered by %s', 'twentytwelve' ), 'WordPress' ); ?></a><?php */?>
		</div><!-- .site-info -->
	</footer><!-- #colophon -->
</div><!-- #page -->
<script src="http://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js"></script>
<script type="text/javascript">
jQuery(document).ready(function($){
	$('ul#menu-main-menu li a').click(function(){
		var target		 = $(this).attr('href');
		var targetClass	 = target.substring(1);
		$('.menu-other').removeAttr('id');
		$('.menu-other').attr('id',targetClass);
		$('div.dynamic_menu').hide();
			$(target).show();
			if(target=="#menu_book_chapter"){
				$('ul.books li a:first').addClass('active');
				var book	= $('ul.books li a:first').attr('data-book');
				$.ajax({
					type:'post',
					url:'<?php echo get_template_directory_uri();?>/menu-ajax.php',
					cache:false,
					data:'book='+book
				}).success(function(response){
					$('ol#chapter_selector').html(response);
				});
			}
			else{
					$('div.dynamic_menu').css('opacity','0');
					if($(target).hasClass('menu_dozen'))
						$(target).removeClass('menu_dozen');
					if($(target).hasClass('menu_truth'))
						$(target).removeClass('menu_truth');
					if($(target).hasClass('menu_falsehoods'))
						$(target).removeClass('menu_falsehoods');
					$(target).addClass(targetClass);
					var cat	=	target.split("_");
					var other_cat	= cat[1];
					$.ajax({
						type:'post',
						url:'<?php echo get_template_directory_uri();?>/menu-ajax.php',
						cache:false,
						data:'other_cat='+other_cat
					}).success(function(response){
						$('div.dynamic_menu').css('opacity','1');
						$('div.menu-other').html(response);
					});
			}
		
	});
	$('ul.books li a').click(function(){
		var book	=	$(this).attr('data-book');
		$('ul.books li a').removeClass('active');
		$(this).addClass('active');
		$.ajax({
			type:'post',
			url:'<?php echo get_template_directory_uri();?>/menu-ajax.php',
			cache:false,
			data:'book='+book
		}).success(function(response){
			$('ol#chapter_selector').html(response);
		});
	});
	$(document).on('click','a.close_btn',function(){
		$('div.dynamic_menu').hide();
	});
	
	$(document).on('click','button#save-setting',function(e){
		e.preventDefault();
		var formData	=	$('form#bible-theme-options').serialize();
		var themeColor,themeFontSize,themeFontStyle;
		if($('input[type="radio"].theme-color:checked')){
			themeColor	= $('input[type="radio"].theme-color:checked').val();
		}
		if($('input[type="radio"].bible_font_size:checked')){
			themeFontSize	= $('input[type="radio"].bible_font_size:checked').val();
		}
		if($('input[type="radio"].bible_font_style:checked')){
			themeFontStyle	= $('input[type="radio"].bible_font_style:checked').val();
		}
		$.ajax({
			type:'post',
			url:'<?php echo get_template_directory_uri();?>/menu-ajax.php',
			cache:false,
			data:formData
		}).success(function(response){
			$('#setting-modal').modal('toggle');
			if(themeColor=='water'){
				$('body').addClass('watertheme');
			}
			else
			{
				if($('body').hasClass('watertheme')){
					$('body').removeClass('watertheme');
				}
			}
			if(themeFontStyle == 'font-merriweather'){
				font_style="'Merriweather', serif";
			}
			else if(themeFontStyle == 'font-timesnewroman'){
				font_style="Times New Roman";
			}
			else{	
				font_style="Helvetica, Arial, sans-serif";
			}
			$('div#content').css('font-family',font_style);
			$('div.breadcrumbs').css('font-family',font_style);
			$('div#content').css('font-size',themeFontSize);
			$('div.breadcrumbs').css('font-size',themeFontSize);
		});
	});

});
</script>
<?php wp_footer(); ?>
</body>
</html>