<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
?>
<?php $bible_font_size = ($_COOKIE['font_size']? $_COOKIE['font_size'] : "12px");?>
<?php 
if($bible_font_size=='12px'):
	$line_height='35px';
elseif($bible_font_size=='14px'):
	$line_height='40px';
elseif($bible_font_size=='16px'):
	$line_height='44px';
elseif($bible_font_size=='18px'):
	$line_height='50px';
elseif($bible_font_size=='22px'):
	$line_height='60px';
endif;

$page = get_page(36823);
$page_subtitle	= get_post_meta( $page->ID, '_subtitle', true );
?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
		<div class="featured-post">
			<?php _e( 'Featured post', 'twentytwelve' ); ?>
		</div>
		<?php endif; ?>
		<header class="entry-header">
			<h1 style="font-size:<?php echo $bible_font_size;?>;" class="entry-title ispage">
				<span class="entry-title-primary"><?php echo $page->post_title;?></span>
				<span class="entry-subtitle"><?php echo $page_subtitle;?></span>
			</h1>
		</header><!-- .entry-header -->


		<?php if ( is_search() ) : // Only display Excerpts for Search ?>
		<div class="entry-summary">
			<?php the_excerpt(); ?>
		</div><!-- .entry-summary -->
		<?php else : ?>
		<div class="entry-content">
			<?php
				
				echo $page->post_content;
			?>
		</div>

		<div id="clonecopy"></div>
		<!-- .entry-content -->
		<?php endif; ?>
<?php /*?>
		<footer class="entry-meta">
			<?php twentytwelve_entry_meta(); ?>
			<?php edit_post_link( __( 'Edit', 'twentytwelve' ), '<span class="edit-link">', '</span>' ); ?>
			<?php if ( is_singular() && get_the_author_meta( 'description' ) && is_multi_author() ) : // If a user has filled out their description and this is a multi-author blog, show a bio on their entries. ?>
				<div class="author-info">
					<div class="author-avatar">
						<?php
						/** This filter is documented in author.php */
					/*	$author_bio_avatar_size = apply_filters( 'twentytwelve_author_bio_avatar_size', 68 );
						echo get_avatar( get_the_author_meta( 'user_email' ), $author_bio_avatar_size );
						?>
					</div><!-- .author-avatar -->
					<div class="author-description">
						<h2><?php printf( __( 'About %s', 'twentytwelve' ), get_the_author() ); ?></h2>
						<p><?php the_author_meta( 'description' ); ?></p>
						<div class="author-link">
							<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
								<?php printf( __( 'View all posts by %s <span class="meta-nav">&rarr;</span>', 'twentytwelve' ), get_the_author() ); ?>
							</a>
						</div><!-- .author-link	-->
					</div><!-- .author-description -->
				</div><!-- .author-info -->
			<?php endif; ?>
		</footer><!-- .entry-meta --><?php*/ ?>
	</article><!-- #post -->
