<?php

/**
* symatic
 *
 * The template used for displaying page content in page.php

 *

 * @package WordPress

 * @subpackage Twenty_Twelve

 * @since Twenty Twelve 1.0

 */

?>

<?php $bible_font_size = ($_COOKIE['font_size']? $_COOKIE['font_size'] : "12px");?>

<?php

if($bible_font_size=='12px'):

	$line_height='42px';

elseif($bible_font_size=='14px'):

	$line_height='46px';

elseif($bible_font_size=='16px'):

	$line_height='50px';

elseif($bible_font_size=='18px'):

	$line_height='53px';

elseif($bible_font_size=='22px'):

	$line_height='58px';

endif;

$is_hibrew = ('H' === $post->post_title[0]) ? 'hebrew' : 'greek';
$font_size = str_replace("px", "", $bible_font_size);
$font_size = $font_size+10;
$lineheight = $lineheight2 = 39;

if($font_size == 32){
    $lineheight = 35;
    $lineheight2 = 29;
}else if($font_size == 36){
    $lineheight = 38;
    $lineheight2 = 32;
}else if($font_size == 28){
    $lineheight2 = 35;
}

if($is_hibrew == 'hebrew'){
    echo '<style>
        article.hebrew div.strongsdef:first-child span:last-child{font-size:'.$font_size.'px !important;line-height:'.$lineheight.'px !important;}
        article.hebrew div.strongsdef:nth-child(2) span:last-child{font-size:'.($font_size+10).'px !important;line-height:'.$lineheight2.'px !important;} 
    </style>';
}else{
    echo '<style>
        article.greek div.strongsdef:first-child span:last-child{font-size: '.$font_size.'px !important; line-height:'.$lineheight.'px !important;} 
    </style>';
}

?>

<?php
if(current_user_can('edit_pages')){
    echo '<p style="text-align: center">
            <a href="'.site_url('symatic_strong_import.php?strong='.get_the_title()).'" target="_blank">Re-fetch</a>
            |
            <a href="'.site_url('wp-admin/post.php?action=edit&post='.get_the_ID()).'" target="_blank">Edit Page</a>
        </p>';
}
?>

	<article id="post-<?php the_ID(); ?>" <?php post_class('strongs '.$is_hibrew); ?>>

		<div class="entry-content">

			<?php the_content(); ?>

			<?php wp_link_pages( array( 'before' => '<div class="page-links">' . __( 'Pages:', 'twentytwelve' ), 'after' => '</div>' ) ); ?>

            <nav class="nav-single">

                <h3 class="assistive-text"><?php _e( 'Post navigation', 'twentytwelve' ); ?></h3>

                <?php

                $title = get_the_title();
                $number = str_replace(array('H','G'), '', $title);

                if($number > 1){
                    $prev_post = $title[0].($number-1);
                    $next_post = $title[0].($number+1);

                    $prev_post_url = site_url('/word/strongs/'.$prev_post);

                    $ppost = get_page_by_title($next_post, OBJECT, 'post');
                    if($ppost && $ppost->post_title == $next_post){
                        $next_post_url = site_url('/word/strongs/'.$next_post);
                    }
                }else{
                    $next_post = $title[0].($number+1);

                    $ppost = get_page_by_title($next_post, OBJECT, 'post');
                    if($ppost && $ppost->post_title == $next_post){
                        $next_post_url = site_url('/word/strongs/'.$next_post);
                    }
                }

                ?>

                <?php if($prev_post_url):?>
                    <span class="nav-previous">
                        <a href="<?php echo $prev_post_url;?>">
                            <?php echo "<< " . $prev_post;?>
                        </a>
                    </span>
                <?php endif;?>

                <?php if($next_post_url):?>
                    <span class="nav-next">
                        <a href="<?php echo $next_post_url;?>">
                            <?php echo $next_post." >>";?>
                        </a>
                    </span>
                <?php endif;?>

            </nav><!-- .nav-single -->

		</div><!-- .entry-content -->

		<footer class="entry-meta">

			<?php edit_post_link( __( 'Edit', 'twentytwelve' ), '<span class="edit-link">', '</span>' ); ?>

		</footer><!-- .entry-meta -->

	</article><!-- #post -->

