<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
?>
<?php $bible_font_size = ($_COOKIE['font_size']? $_COOKIE['font_size'] : "12px");?>
<?php 
if($bible_font_size=='12px'):
	$line_height='18px';
elseif($bible_font_size=='16px'):
	$line_height='24px';
elseif($bible_font_size=='18px'):
	$line_height='28px';
elseif($bible_font_size=='22px'):
	$line_height='30px';
elseif($bible_font_size=='26px'):
	$line_height='34px';
endif;
?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<header class="entry-header">
			<?php if ( ! is_page_template( 'page-templates/front-page.php' ) ) : ?>
			<?php the_post_thumbnail(); ?>
			<?php endif; ?>
&nbsp;
			<h1 style="<?php if(!empty($line_height)){echo "line-height:".$line_height.";";}?>;font-size:<?php echo $bible_font_size;?>;font-weight: bold;" class="entry-title"><?php the_title(); ?></h1>
		</header>

		<div class="entry-content">
			<?php the_content(); ?>
			<?php wp_link_pages( array( 'before' => '<div class="page-links">' . __( 'Pages:', 'twentytwelve' ), 'after' => '</div>' ) ); ?>
		</div><!-- .entry-content -->
		<footer class="entry-meta">
			<?php edit_post_link( __( 'Edit', 'twentytwelve' ), '<span class="edit-link">', '</span>' ); ?>
		</footer><!-- .entry-meta -->
	</article><!-- #post -->
