<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
?>
<?php $bible_font_size = ($_COOKIE['font_size']? $_COOKIE['font_size'] : "12px");?>
<?php 
if($bible_font_size=='12px'):
	$line_height='35px';
elseif($bible_font_size=='14px'):
	$line_height='40px';
elseif($bible_font_size=='16px'):
	$line_height='44px';
elseif($bible_font_size=='18px'):
	$line_height='50px';
elseif($bible_font_size=='22px'):
	$line_height='60px';
endif;

?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<header class="entry-header">
			<h1 class="entry-title" style="<?php if(!empty($line_height)){echo "line-height:".$line_height.";";}?>"><a href="<?php echo get_permalink();?>" style="font-size:<?php echo $bible_font_size;?>;"><?php echo get_post_meta(get_the_ID(),'_subtitle',true); ?></a></h1>
		</header>

		<div class="entry-content">
			<?php the_content(); ?>
			<?php wp_link_pages( array( 'before' => '<div class="page-links">' . __( 'Pages:', 'twentytwelve' ), 'after' => '</div>' ) ); ?>
		</div><!-- .entry-content -->
		<footer class="entry-meta">
			<?php edit_post_link( __( 'Edit', 'twentytwelve' ), '<span class="edit-link">', '</span>' ); ?>
		</footer><!-- .entry-meta -->
	</article><!-- #post -->
