<?php

/**

 * The template for displaying Category pages

 *

 * Used to display archive-type pages for posts in a category.

 *

 * @link http://codex.wordpress.org/Template_Hierarchy

 *

 * @package WordPress

 * @subpackage Twenty_Twelve

 * @since Twenty Twelve 1.0

 */



get_header();?>

	<section id="primary" class="fixed-width">

		<div id="content" role="main" style="font-family:<?php echo $font_style;?>;font-size:<?php echo $bible_font_size;?>;">

		<h3 class="page-title" style="font-size:<?php echo $bible_font_size;?>;"><?php

			$cat_parent	= get_parent_bycatslug(single_cat_title( '', false ));

			echo single_cat_title( '', false )."";

			$cat_name	=	single_cat_title( '', false );

			$cat_id		=	get_cat_ID($cat_name);

			if($cat_parent==4):

				echo " Chapter ".$arr_first_chap[$cat_id];

			endif;

		?></h3>

		<?php

			$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;

			$query_args = array(

			  'post_type' => 'post',

			  'category_name' =>single_cat_title( '', false ),

			  'meta_key' => 'bible_chapter',

			  'meta_value'	=> str_replace(" ","",single_cat_title( '', false ))."-chapter-".$arr_first_chap[$cat_id],

			  'posts_per_page'=> -1,

			  'paged' => $paged,

			  'orderby'=>'ID',

			  'order'=>'ASC'

			);

		?>

		<?php query_posts($query_args);?>

		<?php if ( have_posts() ) : ?>

			<header class="archive-header">

				<h1 class="archive-title"><?php printf( __( 'Category Archives: %s', 'twentytwelve' ), '<span>' . single_cat_title( '', false ) . '</span>' ); ?></h1>



			<?php if ( category_description() ) : // Show an optional category description ?>

				<div class="archive-meta"><?php echo category_description(); ?></div>

			<?php endif; ?>

			</header><!-- .archive-header -->



			<?php

			/* Start the Loop */

			while ( have_posts() ) : the_post();



				/* Include the post format-specific template for the content. If you want to

				 * this in a child theme then include a file called called content-___.php

				 * (where ___ is the post format) and that will be used instead.

				 */

				get_template_part( 'content','category' );



			endwhile;

			

		//twentytwelve_content_nav( 'nav-below' );

			?>

			<nav class="nav-single">

				<div class="nav-previous alignleft"><?php previous_posts_link( '<< Previous' ); ?></div>

				<?php 



				global $wpdb;

				$query="SELECT parent from `bible_term_taxonomy` WHERE term_id = $cat_id";

				$parent	= $wpdb->get_results($query);

				$index 		= array_search($cat_id, $arr_cats);

				$prev_cat_id	=	$arr_cats[$index-1];

				$next_cat_id	=	$arr_cats[$index+1];

				$perv_cat_name	=	get_cat_name($prev_cat_id);

				$next_cat_name	=	get_cat_name($next_cat_id);

				if($cat_id!=4 && $parent[0]->parent ==4 && $index>0):?>

					<div class="nav-previous alignleft"><a href="<?php echo get_permalink(36823).get_cat_slug($prev_cat_id)."/".($arr_last_chap[$prev_cat_id]);?>"><?php echo "<< ".$perv_cat_name." Chapter ".$arr_last_chap[$prev_cat_id];?></a></div>

				<?php endif;

				if($cat_id!=4 && $parent[0]->parent ==4 && $arr_last_chap[$cat_id]>1):?>

					<div class="nav-next alignright">

						<a href="<?php echo get_permalink(36823). get_cat_slug($cat_id)."/".($arr_first_chap[$cat_id]+1);?>"><?php echo $cat_name." Chapter ".($arr_first_chap[$cat_id]+1)." >> ";?></a>

					</div>

				<?php elseif($cat_id!=4 && $parent[0]->parent ==4 && $arr_last_chap[$cat_id]==1):?>

					<div class="nav-next alignright">

						<a href="<?php echo get_permalink(36823). get_cat_slug($next_cat_id)."/".$arr_first_chap[$next_cat_id];?>"><?php echo $next_cat_name." Chapter ".$arr_first_chap[$next_cat_id]." >> ";?></a>

					</div>

				<?php else:?>

					<div class="nav-next alignleft"><?php next_posts_link( 'Next >>' ); ?></div>

				<?php endif;?>

				

			</nav>



		<?php else : ?>

			<?php get_template_part( 'content', 'none' ); ?>

		<?php endif; ?>



		</div><!-- #content -->

	</section><!-- #primary -->



<?php //get_sidebar(); ?>

<?php get_footer(); ?>