<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://symaticsolutions.com
 * @since             1.0.0
 * @package           Symatic_Bible_Index
 *
 * @wordpress-plugin
 * Plugin Name:       Symatic Bible Index
 * Plugin URI:        https://symaticsolutions.com
 * Description:       This plugin is developed to address custom requirements for bible index fetch and show.
 * Version:           1.0.0
 * Author:            Symatic Solutions
 * Author URI:        https://symaticsolutions.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       symatic-bible-index
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'SYMATIC_BIBLE_INDEX_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-symatic-bible-index-activator.php
 */
function activate_symatic_bible_index() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-symatic-bible-index-activator.php';
	Symatic_Bible_Index_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-symatic-bible-index-deactivator.php
 */
function deactivate_symatic_bible_index() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-symatic-bible-index-deactivator.php';
	Symatic_Bible_Index_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_symatic_bible_index' );
register_deactivation_hook( __FILE__, 'deactivate_symatic_bible_index' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-symatic-bible-index.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_symatic_bible_index() {

	$plugin = new Symatic_Bible_Index();
	$plugin->run();

}
run_symatic_bible_index();
