<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://symaticsolutions.com
 * @since      1.0.0
 *
 * @package    Symatic_Bible_Index
 * @subpackage Symatic_Bible_Index/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Symatic_Bible_Index
 * @subpackage Symatic_Bible_Index/public
 * @author     Symatic Solutions <info@symaticsolutions.com>
 */
class Symatic_Bible_Index_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/symatic-bible-index-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/symatic-bible-index-public.js', array( 'jquery' ), $this->version, false );
        wp_localize_script( $this->plugin_name, 'symatic',
            array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );

	}

	public function symatic_the_content($content){
        if ( /*is_singular() && */in_the_loop()/* && is_main_query()*/ ) {
            $postid = get_the_ID();
            $cats = wp_get_post_categories($postid);
            $catsnew = $cats;
            $cateid = get_site_option('symatic_strong_cat');

            unset($catsnew[array_search(4, $catsnew)]);

            $exclude = array(65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78);

            $catsnew = implode("", $catsnew);

            $annotation = get_post_meta($postid, 'symatic_strongs_annotation', true);

            if(!in_array($cateid, $cats) && in_array(4, $cats)){
                return '<div class="drawer" data-id="'.$postid.'">
                        <p>'.$content.'</p>'.
                        (in_array($catsnew, $exclude) ? '' : '<div class="arrow"></div>').
                        ($annotation ? '<div class="annot"></div>':'').
                        '<div class="loader"></div>
                        <div class="drawer-content"></div>
                        <div class="drawer-annotation">'.$annotation.'</div>
                    </div>';
            }else{
                return str_replace('strongsdictionary>', 'strongsdictionary">', $content);
            }

        }

        if(isset($_REQUEST['s']) && !empty($_REQUEST['s'])){
            $searchterm = explode(" ", $_REQUEST['s']);

            return '<p>' . str_replace(array_map(function($val){return $val;}, $searchterm), array_map(function($val){return '<b><u>'.$val.'</u></b>';}, $searchterm) , $content) . '</p>';
        }

        return '<p>'.$content.'</p>';
    }

    public function symatic_get_strongs(){
	    //if(is_ajax()){
            if(!isset($_REQUEST['postid'])){
                wp_send_json_error('Invalid selection');
            }
            $postid = $_REQUEST['postid'];
            $is_hibrew = '';

            $postmeta = get_post_meta($postid, 'symatic_strongs_data', true);
            $postmeta = json_encode($postmeta);
            $postmeta = str_replace('\u05c3"', '"', $postmeta);
            $postmeta = (array)json_decode($postmeta);

            if('H' === $postmeta['links'][0][0]){
                $is_hibrew = 'right';
            }

            $content = '<div class="strongscontainer">';
            foreach($postmeta['links'] as $k=>$v){
                $content .= '<div class="strongs '.$is_hibrew.'">';
                $content .= '<div class="number"><a href="'.site_url('word/strongs/'.$v.'/').'">'.$v.'</a></div>';
                $content .= '<div class="phrase">'.$postmeta['phrase'][$k].'</div>';
                $content .= '<div class="greek">'.$postmeta['greek'][$k].'</div>';
                $content .= '</div>';
            }
            $content .= '</div>';

            wp_send_json_success($content);
        /*}else{
	        wp_send_json_error('Invalid request');
        }*/
    }

}
