<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://symaticsolutions.com
 * @since      1.0.0
 *
 * @package    Symatic_Bible_Index
 * @subpackage Symatic_Bible_Index/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Symatic_Bible_Index
 * @subpackage Symatic_Bible_Index/admin
 * @author     Symatic Solutions <info@symaticsolutions.com>
 */
class Symatic_Bible_Index_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/symatic-bible-index-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/symatic-bible-index-admin.js', array( 'jquery' ), $this->version, false );

	}

	public function symatic_add_meta_box(){
        add_meta_box(
            'symatic_annotation',
            'Annotations',
            array($this, 'symatic_annotation_cb'),
            'post',
            'advanced',
            'high'
        );

        add_meta_box(
            'symatic_strongs_data',
            'Strongs Data',
            array($this, 'symatic_strongs_data_cb'),
            'post',
            'advanced',
            'high'
        );
    }

    public function symatic_annotation_cb($post){
        $value = get_post_meta($post->ID, 'symatic_strongs_annotation', true);
        ?>
        <textarea name="symatic_annotation" id="symatic_annotation" placeholder="Add annotation here"><?php echo $value;?></textarea>
        <?php
    }

    public function symatic_strongs_data_cb($post){
        $value = get_post_meta($post->ID, 'symatic_strongs_data', true);
        ?>
        <textarea name="symatic_strongs_data" id="symatic_strongs_data" placeholder="Strongs json data"><?php echo json_encode($value);?></textarea>
        <?php
    }

    public function symatic_save_post($post_id){
        if (array_key_exists('symatic_annotation', $_POST)) {
            update_post_meta( $post_id, 'symatic_strongs_annotation', $_POST['symatic_annotation'] );
        }

        if (array_key_exists('symatic_strongs_data', $_POST)) {
            $value = (array) json_decode(stripslashes($_POST['symatic_strongs_data']));
            update_post_meta( $post_id, 'symatic_strongs_data', $value );
        }
    }

}
