<?php
/**
 * Created by PhpStorm.
 * User: symatic
 * Date: 14/7/20
 * Time: 9:54 AM
 */

set_time_limit(0);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once __DIR__ . '/wp-load.php';
include_once __DIR__ . '/simple_html_dom.php';

if (!is_admin()) {
    require_once(__DIR__ . '/wp-admin/includes/post.php');
}

define('STRONG_SITE_URL', site_url('/word/strongs/'));
define('THY_WORD_CAT', 4);

$cateid = get_site_option('symatic_strong_cat');
$is_hibrew = true;

$order = !isset($_GET['rev']) ? 'DESC' : 'ASC';

$fh = fopen('symatic_import_log.txt', 'r');
$importlog = fread($fh,100000000);
fclose($fh);

$importlog = explode(",", $importlog);
$importlog = array_filter($importlog);

$the_query = new WP_Query(array(
    'posts_per_page' => 30,
    'post__not_in' => $importlog,
    'orderby' => 'title',
    'order' => 'DESC',
    'category__in' => $cateid,
));

if ($the_query->have_posts()) {
    $posts = $the_query->get_posts();
    foreach ($posts as $post) {
        $is_hibrew = ($post->post_title[0] == 'H') ? true : false;
        $html = str_get_html($post->post_content);
        $dict = $html->find('div.strongsdictionary', 0);

        $newhtml = file_get_html('https://bible.knowing-jesus.com/strongs/'.trim($post->post_title));

        if(!is_object($newhtml->find('.verse-cont', 4))){
             $wordorigin = '<div class="strongsdef"><span class="strongshead">Word Origin:</span><span class="strongsbody"> - </span></div>';
        }else{
            $rootword = $newhtml->find('div.verse-cont', 4)->find('p', 0);

            foreach($rootword->find('a') as $k=>$v){
                $num = trim($v->innertext);

                if($num[0] == 'H' || $num[0] == 'h' || $num[0] == 'G' || $num[0] == 'g'){
                    $rootword->find('a', $k)->href = STRONG_SITE_URL.$num;
                }else{
                    $rootword->find('a', $k)->href = STRONG_SITE_URL.$post->post_title[0].$num;
                }

                $rootword->find('a', $k)->outertext = trim($rootword->find('a', $k)->outertext);
            }

            $wordorigin = '<div class="strongsdef"><span class="strongshead">Word Origin:</span><span class="strongsbody">'.trim($rootword->innertext).'</span></div>';
        }

        if(!is_object($newhtml->find('div.verse-cont', 6))){
            $kjvusage = '<div class="strongsdef"><span class="strongshead">KJV Usage:</span><span class="strongsbody"> - </span></div>';
        }else{
            $kjv = $newhtml->find('div.verse-cont', 6)->find('p', 0);
            $kjvuse = $newhtml->find('div.verse-cont', 6)->find('h2', 0)->plaintext;
            $kjvuse = explode(' ', $kjvuse);
            if(count($kjvuse) <4){
                echo '<pre>';print_r($kjvuse);exit;
            }

            foreach($kjv->find('a') as $k=>$v){
                $num = trim($v->innertext);
                $kjv->find('a', $k)->href = site_url('?s='.$num);
                $kjv->find('a', $k)->outertext = trim($kjv->find('a', $k)->outertext);
            }

            $kjvuse = isset($kjvuse[4]) ? 'Used '.trim($kjvuse[4]).' Total.<br/>' : '';

            $kjvusage = '<div class="strongsdef"><span class="strongshead">KJV Usage:</span><span class="strongsbody">'.$kjvuse.trim($kjv->innertext).'</span></div>';
        }

        $wordorigincount = 0;
        $kjvusecount = 0;

        foreach($dict->find('div.strongsdef') as $key => $def){
            $label = trim($def->find('span', 0)->plaintext);

            if($label == 'Word Origin:'
                || $label == 'Word Origin'
                || strtolower($label) == strtolower('Word Origin:')
                || strtolower($label) == strtolower('Word Origin')
            ){
                if($wordorigincount > 0){
                    $def->outertext = '';
                }else{
                    $def->outertext = $wordorigin;
                }

                $wordorigincount++;
            }

            if($label == 'KJV Usage:'
                || $label == 'KJV Usage'
                || strtolower($label) == strtolower('KJV Usage:')
                || strtolower($label) == strtolower('KJV Usage')
            ){
                if($kjvusecount > 0){
                    $def->outertext = '';
                }else{
                    $def->outertext = $kjvusage;
                }

                $kjvusecount++;
            }
        }

        unset($newhtml);

        wp_update_post(array(
            'ID' => $post->ID,
            'post_content' => preg_replace('/\s+/', ' ', $dict->outertext),
            'post_author' => 1
        ));

        $importlog[] = $post->ID;
    }

    $count = count($importlog);
    $importlog = implode(",", $importlog);
    //echo '<pre>';print_r($importlog);exit;
    $fh = fopen('symatic_import_log.txt', 'w');
    fwrite($fh, $importlog);
    fclose($fh);
} else {
    echo 'There are no more post';
    exit;
}

echo '<html><body>'.$count.'<script>(function(){window.location.reload()})();</script></body></html>';
exit;

exit;


if($the_query->have_posts()){
    $posts = $the_query->get_posts();
    foreach($posts as $post){
        if($post->post_title[0] == 'G'){
            $content = trim(str_replace('"strongsdictionary>', '"strongsdictionary">',$post->post_content));
            $html = str_get_html($content);
            $dict = $html->find('div.strongsdictionary', 0);
            $wordorigin = '';

            foreach($dict->find('div.strongsdef') as $key => $def){
                $label = trim($def->find('span', 0)->plaintext);
                if($label == 'Word Origin:'
                    || $label == 'Word Origin'
                    || strtolower($label) == strtolower('Word Origin:')
                    || strtolower($label) == strtolower('Word Origin')
                ){
                    $wordorigin = $def->outertext;
                    $def->outertext = '';
                }

                if($label == 'Pronunciation:'
                    || $label == 'Pronunciation'
                    || strtolower($label) == strtolower('Pronunciation:')
                    || strtolower($label) == strtolower('Pronunciation')
                ){
                    if(!empty($wordorigin)){
                        $def->outertext .= $wordorigin;
                    }
                }
            }

            wp_update_post(array(
                'ID' => $post->ID,
                'post_content' => preg_replace('/\s+/', ' ', $dict->outertext),
                'post_author' => 1
            ));
        }
        $importlog[] = $post->ID;
    }

    $count = count($importlog);
    $importlog = implode(",", $importlog);
    //echo '<pre>';print_r($importlog);exit;
    $fh = fopen('symatic_import_log.txt', 'w');
    fwrite($fh, $importlog);
    fclose($fh);

    echo '<html><body>'.$count.'<script>(function(){setTimeout(function(){window.location.reload()}, 600)})();</script></body></html>';
    exit;
}else{
    echo 'No more post';
    exit;
}

exit;






// The Loop
if ($the_query->have_posts()) {
    $posts = $the_query->get_posts();
    echo '<pre>';print_r($posts);exit;
    foreach ($posts as $post) {
        $is_hibrew = ($post->post_title[0] == 'H') ? true : false;
        //if(!$is_hibrew) continue;
        $content = trim(str_replace('"strongsdictionary>', '"strongsdictionary">',$post->post_content));
        $html = str_get_html($content);
        $dict = $html->find('div.strongsdictionary', 0);

        $newhtml = file_get_html('https://bible.knowing-jesus.com/strongs/'.trim($post->post_title));

        if(!is_object($newhtml->find('.verse-cont', 4))){
            $importlog[] = $post->ID;
            continue;
        }

        $rootword = $newhtml->find('div.verse-cont', 4)->find('p', 0);
        foreach($rootword->find('a') as $k=>$v){
            $num = trim($v->innertext);
            $rootword->find('a', $k)->href = STRONG_SITE_URL.($num[0] == 'H' ? $num : 'H'.$num);
            $rootword->find('a', $k)->outertext = trim($rootword->find('a', $k)->outertext);
        }

        $kjv = $newhtml->find('div.verse-cont', 6)->find('p', 0);
        foreach($kjv->find('a') as $k=>$v){
            $num = trim($v->innertext);
            $kjv->find('a', $k)->href = site_url('?s='.$num);
            $kjv->find('a', $k)->outertext = trim($kjv->find('a', $k)->outertext);
        }

        $greekPartofSpeech = '';

        foreach($dict->find('div.strongsdef') as $key => $def){
            $label = trim($def->find('span', 0)->plaintext);

            // change transliteration if hibrew
            if(!$is_hibrew){
                if($label == 'Part of Speech:'
                    || $label == 'Part of Speech'
                    || strtolower($label) == strtolower('Part of Speech:')
                    || strtolower($label) == strtolower('Part of Speech')
                ){
                    $greekPartofSpeech = $def->outertext;
                    $def->outertext = '';
                }
            }
        }

        foreach($dict->find('div.strongsdef') as $key => $def){
            $label = trim($def->find('span', 0)->plaintext);

            // change transliteration if hibrew
            if($is_hibrew){
                if($key==0){
                    //get and set paleo hebrew
                    $remotehtml = file_get_html("https://thekingjam.es/strongs/".trim($post->post_title));
                    if(is_object($remotehtml->find('h2.hebrew-font', 0))){
                        $def->outertext = '<div class="strongsdef"><span class="strongshead">Paleo Hebrew:</span><span class="strongsbody">'.$remotehtml->find('h2.hebrew-font', 0)->plaintext.'</span></div>';
                        //$def->save();
                    }
                }

                if($label == 'Hebrew:'
                    || $label == 'Hebrew'
                    || strtolower($label) == strtolower('Hebrew:')
                    || strtolower($label) == strtolower('Hebrew')
                ){
                    $def->find('span.strongshead', 0)->innertext = 'Assyrian Hebrew:';
                    $def->outertext .= '<div class="strongsdef"><span class="strongshead">Strong\'s #:</span><span class="strongsbody">'.trim($post->post_title).'</span></div>';
                }

                if($label == 'Transliteration:'
                    || $label == 'Transliteration'
                    || strtolower($label) == strtolower('Transliteration:')
                    || strtolower($label) == strtolower('Transliteration')
                ){
                    $def->find('span.strongsbody', 0)->innertext = trim($remotehtml->find('div.py-2 div', 0)->plaintext);
                }

                if($label == 'Part of Speech:'
                    || $label == 'Part of Speech'
                    || strtolower($label) == strtolower('Part of Speech:')
                    || strtolower($label) == strtolower('Part of Speech')
                ){
                    $def->outertext .= '<div class="strongsdef"><span class="strongshead">Word Origin:</span><span class="strongsbody">'.trim($rootword->innertext).'</span></div>';
                }

            }else{
                if($key==0){
                    $def->outertext = '';
                }

                if($label == 'Greek:'
                    || $label == 'Greek'
                    || strtolower($label) == strtolower('Greek:')
                    || strtolower($label) == strtolower('Greek')
                ){
                    $def->outertext .= '<div class="strongsdef"><span class="strongshead">Strong\'s #:</span><span class="strongsbody">'.trim($post->post_title).'</span></div>';
                    $html->save();
                }

                if($label == 'Transliteration:'
                    || $label == 'Transliteration'
                    || strtolower($label) == strtolower('Transliteration:')
                    || strtolower($label) == strtolower('Transliteration')
                ){
                    $def->outertext .= $greekPartofSpeech.'<div class="strongsdef"><span class="strongshead">Word Origin:</span><span class="strongsbody">'.trim($rootword->innertext).'</span></div>';
                }
            }
        }

        unset($remotehtml);

        $dict->find('div.strongsdef', $key)->outertext .= '<div class="strongsdef"><span class="strongshead">KJV Usage:</span><span class="strongsbody">'.trim($kjv->innertext).'</span></div>';

        //echo '<pre><br/>';print_r($dict->outertext);exit;
        wp_update_post(array(
            'ID' => $post->ID,
            'post_content' => preg_replace('/\s+/', ' ', $dict->outertext),
            'post_author' => 1
        ));

        $importlog[] = $post->ID;
    }

    $count = count($importlog);
    $importlog = implode(",", $importlog);
    //echo '<pre>';print_r($importlog);exit;
    $fh = fopen('symatic_import_log.txt', 'w');
    fwrite($fh, $importlog);
    fclose($fh);
} else {
    echo 'There are no more post';
    exit;
}

//echo '<pre>';
//print_r($importlog);
echo '<html><body>'.$count.'<script>(function(){window.location.reload()})();</script></body></html>';
exit;
?>